% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_get_basic_info_methods.R
\name{get-names}
\alias{get-names}
\alias{get_feature_ids}
\alias{get_feature_names}
\alias{get_cell_barcodes}
\alias{get_feature_ids,ondisc_matrix-method}
\alias{get_feature_names,ondisc_matrix-method}
\alias{get_cell_barcodes,ondisc_matrix-method}
\alias{get_feature_ids,metadata_ondisc_matrix-method}
\alias{get_feature_names,metadata_ondisc_matrix-method}
\alias{get_cell_barcodes,metadata_ondisc_matrix-method}
\alias{get_feature_ids,multimodal_ondisc_matrix-method}
\alias{get_feature_names,multimodal_ondisc_matrix-method}
\alias{get_cell_barcodes,multimodal_ondisc_matrix-method}
\title{Get cell barcodes, feature names, and feature IDs}
\usage{
get_feature_ids(x)

get_feature_names(x)

get_cell_barcodes(x)

\S4method{get_feature_ids}{ondisc_matrix}(x)

\S4method{get_feature_names}{ondisc_matrix}(x)

\S4method{get_cell_barcodes}{ondisc_matrix}(x)

\S4method{get_feature_ids}{metadata_ondisc_matrix}(x)

\S4method{get_feature_names}{metadata_ondisc_matrix}(x)

\S4method{get_cell_barcodes}{metadata_ondisc_matrix}(x)

\S4method{get_feature_ids}{multimodal_ondisc_matrix}(x)

\S4method{get_feature_names}{multimodal_ondisc_matrix}(x)

\S4method{get_cell_barcodes}{multimodal_ondisc_matrix}(x)
}
\arguments{
\item{x}{an object of class \code{ondisc_matrix}, \code{covaraite_ondisc_matrix}, or \code{multimodal_ondisc_matrix}.}
}
\value{
A character vector or list of character vectors containing the requested identifiers.
}
\description{
Obtain cell barcodes, feature names, and feature IDs of an \code{ondisc_matrix}, \code{metadata_ondisc_matrix},
or \code{multimodal_ondisc_matrix}.
}
\details{
The following functions can be used to obtain feature and cell identifiers:
\itemize{
\item \code{get_cell_barcodes}: return the cell barcodes.
\item \code{get_feature_names}: return the feature names.
\item \code{get_feature_ids}: return the IDs of the features.
}

In general, these functions return a character vector containing the requested identifiers. When
\code{get_feature_names} or \code{get_feature_ids} is called on a \code{multimodal_ondisc_matrix}, the function instead
returns a list containing the feature names and feature IDs, respectively, of the modalities contained
within the \code{multimodal_ondisc_matrix}.
}
\examples{
# NOTE: You must create the RDS files "expressions.rds" and
# "perturbations.rds" to run this example. Navigate to the help file of
# "create_ondisc_matrix_from_mtx" (via ?create_ondisc_matrix_from_mtx),
# and execute both code blocks.

# ondisc_matrix
h5_fp <- paste0(tempdir(), "/expressions.h5")
if (file.exists(h5_fp)) {
odm <- ondisc_matrix(h5_file = h5_fp)
barcodes <- get_cell_barcodes(odm)
feature_names <- get_feature_names(odm)
feature_ids <- get_feature_ids(odm)
}

# metadata_ondic_matrix
expressions_fp <- paste0(tempdir(), "/expressions.rds")
if (file.exists(expressions_fp)) {
expressions <- readRDS(expressions_fp)
barcodes <- get_cell_barcodes(odm)
feature_names <- get_feature_names(odm)
feature_ids <- get_feature_ids(odm)
}

# multimodal_ondisc_matrix
expression_fp <- paste0(tempdir(), "/expressions.rds")
perturbations_fp <- paste0(tempdir(), "/perturbations.rds")
if (file.exists(expression_fp) && file.exists(perturbations_fp)) {
    crispr_experiment <- multimodal_ondisc_matrix(list(expressions = readRDS(expression_fp),
    perturbations = readRDS(perturbations_fp)))
    barcodes <- get_cell_barcodes(crispr_experiment)
    feature_ids <- get_feature_ids(crispr_experiment)
}
}
