% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_classes.R
\name{metadata_ondisc_matrix}
\alias{metadata_ondisc_matrix}
\title{\code{metadata_ondisc_matrix} class}
\usage{
metadata_ondisc_matrix(ondisc_matrix, cell_covariates, feature_covariates)

metadata_ondisc_matrix(ondisc_matrix, cell_covariates, feature_covariates)
}
\arguments{
\item{ondisc_matrix}{an \code{ondisc_matrix}.}

\item{cell_covariates}{a data frame storing the cell-specific covariates.}

\item{feature_covariates}{a data frame storing the feature-specific covariates.}
}
\value{
a \code{metadata_ondisc_matrix}.
}
\description{
A \code{metadata_ondisc_matrix} stores an \code{ondisc_matrix}, along with cell-specific and feature-specific covariate matrices.

Construct a \code{metadata_ondisc_matrix} by passing an \code{ondisc_matrix}, along with its associated \code{cell_covariates} and \code{feature_covariates}.
}
\section{Slots}{

\describe{
\item{\code{ondisc_matrix}}{an ondisc_matrix.}

\item{\code{cell_covariates}}{a data frame of cell covariates.}

\item{\code{feature_covariates}}{a data frame of feature covariates.}
}}

\examples{
# NOTE: You must create the HDF5 file "expressions.h5" and the RDS file
# "expressions.rds" to run this example. Navigate to the help file of
# "create_ondisc_matrix_from_mtx" (via ?create_ondisc_matrix_from_mtx),
# and execute the code in the first code block.
covariates_fp <- paste0(tempdir(), "/expressions.rds")
h5_fp <-  paste0(tempdir(), "/expressions.h5")
if (file.exists(covariates_fp) && file.exists(h5_fp)) {
covariate_odm <- readRDS(covariates_fp)
cell_covariate_matrix <- covariate_odm@cell_covariates
feature_covariate_matrix <- covariate_odm@feature_covariates
covariate_odm_copy <- metadata_ondisc_matrix(
ondisc_matrix = ondisc_matrix(h5_file = h5_fp),
cell_covariates = cell_covariate_matrix,
feature_covariates = feature_covariate_matrix)
}
}
