% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_depths_profile.R
\name{create_depths_profile}
\alias{create_depths_profile}
\title{Create database and ggplot graphic of allele reads depths}
\usage{
create_depths_profile(
  onemap.obj = NULL,
  vcfR.object = NULL,
  vcf = NULL,
  parent1 = NULL,
  parent2 = NULL,
  vcf.par = "AD",
  recovering = FALSE,
  mks = NULL,
  inds = NULL,
  GTfrom = "onemap",
  alpha = 1,
  rds.file = "data.rds",
  y_lim = NULL,
  x_lim = NULL,
  verbose = TRUE
)
}
\arguments{
\item{onemap.obj}{an object of class \code{onemap}.}

\item{vcfR.object}{object of class vcfR;}

\item{vcf}{path to VCF file.}

\item{parent1}{a character specifying the first parent ID}

\item{parent2}{a character specifying the second parent ID}

\item{vcf.par}{the vcf parameter that store the allele depth information.}

\item{recovering}{logical. If TRUE, all markers in vcf are consider, if FALSE only those in onemap.obj}

\item{mks}{a vector of characters specifying the markers names to be considered or NULL to consider all markers}

\item{inds}{a vector of characters specifying the individual names to be considered or NULL to consider all individuals}

\item{GTfrom}{the graphic should contain the genotypes from onemap.obj or from the vcf? Specify using "onemap", "vcf" or "prob".}

\item{alpha}{define the transparency of the dots in the graphic}

\item{rds.file}{rds file name to store the data frame with values used to build the graphic}

\item{y_lim}{set scale limit for y axis}

\item{x_lim}{set scale limit for x axis}

\item{verbose}{If \code{TRUE}, print tracing information.}
}
\value{
an rds file and a ggplot graphic.
}
\description{
Create database and ggplot graphic of allele reads depths
}
\seealso{
\code{\link[onemap]{onemap_read_vcfR}}
}
\author{
Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
\keyword{alleles}
\keyword{depth}
