% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_missing}
\alias{filter_missing}
\title{Filter markers according with a missing data threshold}
\usage{
filter_missing(
  onemap.obj = NULL,
  threshold = 0.25,
  by = "markers",
  verbose = TRUE
)
}
\arguments{
\item{onemap.obj}{an object of class \code{onemap}.}

\item{threshold}{a numeric from 0 to 1 to define the threshold of missing data allowed}

\item{by}{character defining if `markers` or `individuals` should be filtered}

\item{verbose}{A logical, if TRUE it output progress status
information.}
}
\value{
An object of class \code{onemap}, i.e., a list with the following
components: \item{geno}{a matrix with integers indicating the genotypes
read for each marker. Each column contains data for a marker and each row
represents an individual.} \item{n.ind}{number of individuals.}
\item{n.mar}{number of markers.} \item{segr.type}{a vector with the
segregation type of each marker, as \code{strings}.} \item{segr.type.num}{a
vector with the segregation type of each marker, represented in a
simplified manner as integers, i.e. 1 corresponds to markers of type
\code{"A"}; 2 corresponds to markers of type \code{"B1.5"}; 3 corresponds
to markers of type \code{"B2.6"}; 4 corresponds to markers of type
\code{"B3.7"}; 5 corresponds to markers of type \code{"C.8"}; 6 corresponds
to markers of type \code{"D1"} and 7 corresponds to markers of type
\code{"D2"}. Markers for F2 intercrosses are coded as 1; all other crosses
are left as \code{NA}.} \item{input}{the name of the input file.}
\item{n.phe}{number of phenotypes.} \item{pheno}{a matrix with phenotypic
values. Each column contains data for a trait and each row represents an
individual.} \item{error}{matrix containing HMM emission probabilities}
}
\description{
Filter markers according with a missing data threshold
}
\examples{

  data(onemap_example_out)
  filt_obj <- filter_missing(onemap_example_out, threshold=0.25)
 
}
\author{
Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
