% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{propagate_relations}
\alias{propagate_relations}
\title{Select terms by propagating relations from a set of terms}
\usage{
propagate_relations(
  ontology,
  roots,
  relations,
  use_inverse_relations = FALSE,
  exclude_roots = FALSE
)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{roots}{Character vector of term IDs from which relations will be propagated.}

\item{relations}{Character vector given names of transitive relations to be propagated.}

\item{use_inverse_relations}{Boolean vector indicating whether to propagate inverse relations. If \code{use_inverse_relations} is the same length as \code{relations}, each element determines whether the corresponding relation in \code{relations} is inverted.}

\item{exclude_roots}{Boolean determining whether to remove the given \code{roots} terms from the result.}
}
\value{
Character vector of terms
}
\description{
An `ontology_index` can contain multiple relations (for example in the case of the Gene Ontology, \code{"is_a"} and \code{"part_of"} could be stored as separate properties in an `ontology_index`). Transitive relations (i.e. relations such that x related to y and y related to z implies x related to z, for example the relation 'is an ancestor of') stored by an `ontology_index` can be propagated using this function. The 'inverse relations' (i.e. x inversely related to y if y related to x) can also be propagated by setting the \code{use_inverse_relations} parameter to \code{TRUE}.
}
\seealso{
\code{\link{get_ancestors}}, \code{\link{get_descendants}}
}
