% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_likelihoodEqs.R
\name{negLLzero}
\alias{negLLzero}
\title{Likelihood with zero counts}
\usage{
negLLzero(theta, N, E)
}
\arguments{
\item{theta}{A numeric vector of hyperparameters ordered as:
\eqn{\alpha_1, \beta_1, \alpha_2, \beta_2, P}.}

\item{N}{A whole number vector of actual counts from
\code{\link{processRaw}}.}

\item{E}{A numeric vector of expected counts from \code{\link{processRaw}}.}
}
\value{
A scalar negative log-likelihood value.
}
\description{
\code{negLLzero} computes the negative log-likelihood based on the
unconditional marginal distribution of \emph{N} (equation 12 in DuMouchel
1999, except taking negative natural log). This function is minimized to
estimate the hyperparameters of the prior distribution. Use this function if
including zero counts but not squashing data. Generally this function is not
recommended (\code{\link{negLLsquash}} is typically more efficient).
}
\details{
The marginal distribution of the counts, \emph{N}, is a mixture of
  two negative binomial distributions. The hyperparameters for the prior
  distribution (mixture of gammas) are estimated by optimizing the likelihood
  equation from this marginal distribution.

The hyperparameters are:
  \itemize{
    \item{\eqn{\alpha_1, \beta_1}: }{Parameters of the first component of the
      marginal distribution of the counts (also the prior distribution)}
    \item{\eqn{\alpha_2, \beta_2}: }{Parameters of the second component}
    \item{\eqn{P}: }{Mixture fraction}
}

This function will not need to be called directly if using
  \code{\link{exploreHypers}} or \code{\link{autoHyper}}.
}
\section{Warnings}{

  Make sure \emph{N} actually contains zeroes before using this function. You
  should have used the \code{zeroes = TRUE} option when calling the
  \code{\link{processRaw}} function.


  Make sure the data were not squashed before using this function.
}

\references{
DuMouchel W (1999). "Bayesian Data Mining in Large Frequency
  Tables, With an Application to the FDA Spontaneous Reporting System."
  \emph{The American Statistician}, 53(3), 177-190.
}
\seealso{
\code{\link[stats]{nlm}}, \code{\link[stats]{nlminb}}, and
  \code{\link[stats]{optim}} for optimization

Other negative log-likelihood functions: \code{\link{negLLsquash}},
  \code{\link{negLLzeroSquash}}, \code{\link{negLL}}
}
\keyword{openEBGM}
