/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.thai;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.TagDictionary;

public class PosTagger
extends POSTaggerME {
    public PosTagger(String modelFile, Dictionary dict, TagDictionary tagdict) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(dict), tagdict);
    }

    public PosTagger(String modelFile, TagDictionary tagdict) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(null), tagdict);
    }

    public PosTagger(String modelFile) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(null));
    }

    private static MaxentModel getModel(String name) {
        try {
            return new SuffixSensitiveGISModelReader(new File(name)).getModel();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: PosTagger [-td tagdict] model < tokenized_sentences");
            System.exit(1);
        }
        int ai = 0;
        boolean test = false;
        String tagdict = null;
        while (ai < args.length && args[ai].startsWith("-")) {
            if (args[ai].equals("-test")) {
                ++ai;
                test = true;
                continue;
            }
            if (!args[ai].equals("-td")) continue;
            tagdict = args[ai + 1];
            ai += 2;
        }
        String modelFile = args[ai++];
        PosTagger tagger = tagdict != null ? new PosTagger(modelFile, (TagDictionary)new POSDictionary(tagdict, "UTF-8", true)) : new PosTagger(modelFile);
        if (test) {
            System.out.println(tagger.tag(args[ai]));
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            String line = in.readLine();
            while (line != null) {
                out.println(tagger.tag(line));
                line = in.readLine();
            }
        }
    }
}

