/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import opennlp.maxent.DataStream;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.tools.lang.thai.SentenceContextGenerator;
import opennlp.tools.sentdetect.AbstractEndOfSentenceScanner;
import opennlp.tools.sentdetect.DefaultSDContextGenerator;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.SDEvent;

public class SDEventStream
implements EventStream {
    private DataStream data;
    private String next;
    private SDEvent head = null;
    private SDEvent tail = null;
    private SDContextGenerator cg;
    private StringBuffer sBuffer = new StringBuffer();
    private EndOfSentenceScanner scanner;

    public SDEventStream(DataStream d) {
        this(d, new opennlp.tools.lang.english.EndOfSentenceScanner(), new DefaultSDContextGenerator(opennlp.tools.lang.english.EndOfSentenceScanner.eosCharacters));
    }

    public SDEventStream(DataStream d, EndOfSentenceScanner s) {
        this(d, s, new DefaultSDContextGenerator(s.getEndOfSentenceCharacters()));
    }

    public SDEventStream(DataStream d, EndOfSentenceScanner s, SDContextGenerator cg) {
        this.data = d;
        this.scanner = s;
        this.cg = cg;
        if (this.data.hasNext()) {
            String current = (String)this.data.nextToken();
            if (this.data.hasNext()) {
                this.next = (String)this.data.nextToken();
            }
            this.addNewEvents(current);
        }
    }

    public Event nextEvent() {
        SDEvent top = this.head;
        this.head = this.head.next;
        if (null == this.head) {
            this.tail = null;
        }
        return top;
    }

    private void addNewEvents(String s) {
        StringBuffer sb = this.sBuffer;
        sb.append(s.trim());
        if (!s.equals("")) {
            if (this.next != null) {
                int posAfterFirstWordInNext = this.next.indexOf(" ");
                if (posAfterFirstWordInNext != -1) {
                    sb.append(" ");
                    sb.append(this.next.substring(0, posAfterFirstWordInNext));
                } else {
                    sb.append(" ");
                    sb.append(this.next);
                }
            } else {
                sb.append(" ");
            }
        }
        Iterator i = this.scanner.getPositions(sb).iterator();
        while (i.hasNext()) {
            Integer candidate = (Integer)i.next();
            String type = i.hasNext() ? "F" : "T";
            SDEvent evt = new SDEvent(type, this.cg.getContext(sb, candidate));
            if (null != this.tail) {
                this.tail.next = evt;
                this.tail = evt;
                continue;
            }
            if (null == this.head) {
                this.head = evt;
                continue;
            }
            if (null != this.head.next) continue;
            this.head.next = this.tail = evt;
        }
        sb.setLength(0);
    }

    public boolean hasNext() {
        if (null != this.head) {
            return true;
        }
        while (null == this.head && this.next != null) {
            String current = this.next;
            this.next = this.data.hasNext() ? (String)this.data.nextToken() : null;
            this.addNewEvents(current);
        }
        return null != this.head;
    }

    private static void usage() {
        System.err.println("SDEventStream [-encoding charset] [-lang (english|spanish|thai)] < trainingData");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        int ai = 0;
        String encoding = "US-ASCII";
        String lang = "english";
        while (ai < args.length && args[ai].startsWith("-")) {
            if (args[ai].equals("-encoding")) {
                if (++ai < args.length) {
                    encoding = args[ai];
                    ++ai;
                    continue;
                }
                SDEventStream.usage();
                continue;
            }
            if (args[ai].equals("-lang")) {
                if (++ai < args.length) {
                    lang = args[ai];
                    ++ai;
                    continue;
                }
                SDEventStream.usage();
                continue;
            }
            SDEventStream.usage();
        }
        AbstractEndOfSentenceScanner scanner = null;
        DefaultSDContextGenerator cg = null;
        if (lang == null || lang.equals("english") || lang.equals("spanish")) {
            scanner = new opennlp.tools.lang.english.EndOfSentenceScanner();
            cg = new DefaultSDContextGenerator(scanner.getEndOfSentenceCharacters());
        } else if (lang.equals("thai")) {
            scanner = new opennlp.tools.lang.thai.EndOfSentenceScanner();
            cg = new SentenceContextGenerator();
        } else {
            SDEventStream.usage();
        }
        SDEventStream es = new SDEventStream((DataStream)new PlainTextByLineDataStream((Reader)new InputStreamReader(System.in, encoding)), scanner, cg);
        while (es.hasNext()) {
            System.out.println(es.nextEvent());
        }
    }
}

