% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSMF.r
\name{getCSMF}
\alias{getCSMF}
\title{Obtain CSMF from fitted model}
\usage{
getCSMF(x, CI = 0.95, interVA.rule = TRUE)
}
\arguments{
\item{x}{a fitted object from \code{codeVA}.}

\item{CI}{For \code{insilico} object only, specifying the credible interval to return. 
Default value to be 0.95.}

\item{interVA.rule}{Logical indicator for \code{interVA} object only. If TRUE, it means
only up to top 3 causes for each death are used to calculate CSMF and the rest are 
categorized as "undetermined"}
}
\value{
a vector or matrix of CSMF for all causes.
}
\description{
Obtain CSMF from fitted model
}
\examples{
\dontrun{
library(InSilicoVA)
data(RandomVA1)
# for illustration, only use interVA on 100 deaths
fit <- codeVA(RandomVA1[1:100, ], data.type = "WHO2012", model = "InterVA", 
                  version = "4.03", HIV = "h", Malaria = "l", write=FALSE)
getCSMF(fit)
library(InterVA5)
data(RandomVA5)
fit <- codeVA(RandomVA5[1:100, ], data.type = "WHO2016", model = "InterVA", 
                  version = "5", HIV = "h", Malaria = "l", write=FALSE)
getCSMF(fit)
}

}
