% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caching.R
\name{oa_cache}
\alias{oa_cache}
\alias{oa_cache_delete}
\alias{oa_cache_delete_all}
\alias{oa_cache_details}
\alias{oa_cache_list}
\title{Manage cached files}
\usage{
oa_cache_list()

oa_cache_delete(files, force = FALSE)

oa_cache_delete_all(force = FALSE)

oa_cache_details(files = NULL)
}
\arguments{
\item{files}{File name or names}

\item{force}{(logical) Should files be force deleted? Default: \code{FALSE}}
}
\description{
Manage cached files
}
\details{
\code{cache_delete} only accepts 1 file name, while \code{cache_delete_all}
doesn't accept any names, but deletes all files. For deleting many specific files,
use \code{cache_delete} in a \code{\link{lapply}} type call

We cache using \code{\link[rappdirs]{user_cache_dir}}, find your cache
folder by executing \code{rappdirs::user_cache_dir("openadds-cache")}
}
\examples{
\dontrun{
# list files in cache
oa_cache_list()

# List info for single files
oa_cache_details(files = oa_cache_list()[1])
oa_cache_details(files = oa_cache_list()[2])

# List info for all files
oa_cache_details()

# delete files by name in cache
# oa_cache_delete(files = oa_cache_list()[1])

# delete all files in cache - BE CAREFUL, MAKE SURE YOU WANT TO DO THIS
# oa_cache_delete_all()
}
}

