% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_searchNetwork.R
\name{searchNetwork}
\alias{searchNetwork}
\title{Geographically search the air quality networks made available by
\code{\link[openair:importMeta]{openair::importMeta()}}}
\usage{
searchNetwork(
  lat,
  lng,
  source = "aurn",
  year = NULL,
  site_type = NULL,
  variable = NULL,
  max_dist = NULL,
  n = NULL,
  map = TRUE
)
}
\arguments{
\item{lat, lng}{The latitude and longitude for the location of interest.}

\item{source}{One or more air quality networks for which data is available
through openair. Available networks include:
\itemize{
\item \code{"aurn"},  The UK Automatic Urban and Rural Network.
\item \code{"aqe"},  The Air Quality England Network.
\item \code{"saqn"},  The Scottish Air Quality Network.
\item \code{"waqn"},  The Welsh Air Quality Network.
\item \code{"ni"},  The Northern Ireland Air Quality Network.
\item \code{"local"},  Locally managed air quality networks in England.
\item \code{"kcl"}, King's College London networks.
\item \code{"europe"}, European AirBase/e-reporting data.
There are two additional options provided for convenience:
\item \code{"ukaq"} will return metadata for all networks for which data is imported by \code{\link[openair:importUKAQ]{importUKAQ()}} (i.e., AURN, AQE, SAQN, WAQN, NI, and the local networks).
\item \code{"all"} will import all available metadata (i.e., \code{"ukaq"} plus \code{"kcl"} and \code{"europe"}).
}}

\item{year}{If a single year is selected, only sites that were open at some
point in that year are returned. If \code{all = TRUE} only sites that
measured a particular pollutant in that year are returned. Year can also be
a sequence e.g. \code{year = 2010:2020} or of length 2 e.g. \code{year = c(2010, 2020)}, which will return only sites that were open over the
duration. Note that \code{year} is ignored when the \code{source} is either
\code{"kcl"} or \code{"europe"}.}

\item{site_type}{Optional. One or more site types with which to subset the
site metadata. For example, \code{site_type = "urban background"} will only
search urban background sites.}

\item{variable}{Optional. One or more variables of interest with which to
subset the site metadata. For example, \code{variable = c("pm10", "co")} will
search sites that measure PM10 and/or CO.}

\item{max_dist}{Optional. A maximum distance from the location of interest in
kilometres.}

\item{n}{Optional. The maximum number of sites to return.}

\item{map}{If \code{TRUE}, the default, \code{\link[=searchNetwork]{searchNetwork()}} will return a \code{leaflet}
map. If \code{FALSE}, it will instead return a \link[tibble:tibble-package]{tibble}.}
}
\value{
Either a \link[tibble:tibble-package]{tibble} or \code{leaflet} map.
}
\description{
While \code{\link[=networkMap]{networkMap()}} visualises entire UK air quality networks,
\code{\link[=searchNetwork]{searchNetwork()}} can subset specific networks to find air quality sites near
to a specific site of interest (for example, the location of known industrial
activity, or the centroid of a specific urban area).
}
\details{
Data subsetting progresses in the order in which the arguments are given;
first \code{source} and \code{year}, then \code{site_type} and \code{variable}, then \code{max_dist},
and finally \code{n}.
}
\examples{
\dontrun{
# get all AURN sites open in 2020 within 20 km of Buckingham Palace
palace <- convertPostcode("SW1A1AA")
searchNetwork(lat = palace$lat, lng = palace$lng, max_dist = 20, year = 2020)
}
}
\seealso{
Other uk air quality network mapping functions: 
\code{\link{networkMap}()}
}
\concept{uk air quality network mapping functions}
