% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai.R
\name{openai}
\alias{openai}
\title{An R6 Class Interface to OpenAI API}
\description{
Provides methods to interact with OpenAI API including
  fetching model details, generating completions, managing files, and more.
  Always ensure that the API key is kept private.
}
\examples{
key <- "YOUR_API_KEY"
#NOTE To retrieve the correct data, it is necessary to provide an 'openaikey';
# otherwise, an exception will be returned.
aaa <- openai$new(key)
#if need proxy
#aaa$set_proxy("127.0.0.1", 8890)
# List model
aaa$get_model_list()
\donttest{
#The following request will cause a timeout when the correct key is not present,
# so it is not necessary to test it during the check.
# Upload a file
file_id <- aaa$files_upload(path = "../../model_newbuy/gpt_F_tuning/st03/test_st04_v01.jsonl")

# Delete a file
aaa$files_delete(file_id$id, verbosity = 0)

# Retrieve a file's details
aaa$files_retrieve(NULL, verbosity = 0)
# Get a list of files
aaa$files_get_list()
# List fine-tuning jobs
aaa$fine_tuning_jobs_list(limit = 2, verbosity = 3)

# Retrieve details of a specific fine-tuning job
aaa$fine_tuning_jobs_retrieve("ftjob-XVOnvAP2owx4fh4B65QQP0Bk", verbosity = 0)

# Get events related to a specific fine-tuning job
aaa$fine_tuning_jobs_events("ftjob-XVOnvAP2owx4fh4B65QQP0Bk", verbosity = 3)
# Compute embeddings for input data
aaa$embeddings(model = "text-embedding-ada-002", input = "who are you?")
# chat test not stream
streamlg <- aaa$get_completions_query(
  prompt = "Please explain the World Wars?",
  model = "davinci-002",
  stream = FALSE,
  max_tokens = 20,
  num = 4,
  verbosity = 0
)

# chat test stream
streamlg <- aaa$get_chat_completions_query(
  messages = data.frame(role = c("system", "user"),
                        content = c("You are a assistant.", "How's the weather today?")),
  model = "gpt-3.5-turbo",
  stream = TRUE,
  max_tokens = 10
)

streamlg$get_state()
streamlg$next_value
streamlg$close()
streamlg$next_value
streamlg$get_state()
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-openai-new}{\code{openai$new()}}
\item \href{#method-openai-set_proxy}{\code{openai$set_proxy()}}
\item \href{#method-openai-get_model_list}{\code{openai$get_model_list()}}
\item \href{#method-openai-get_model_retrieve}{\code{openai$get_model_retrieve()}}
\item \href{#method-openai-get_completions_query}{\code{openai$get_completions_query()}}
\item \href{#method-openai-get_chat_completions_query}{\code{openai$get_chat_completions_query()}}
\item \href{#method-openai-files_upload}{\code{openai$files_upload()}}
\item \href{#method-openai-files_get_list}{\code{openai$files_get_list()}}
\item \href{#method-openai-files_delete}{\code{openai$files_delete()}}
\item \href{#method-openai-files_retrieve}{\code{openai$files_retrieve()}}
\item \href{#method-openai-fine_tuning_jobs_create}{\code{openai$fine_tuning_jobs_create()}}
\item \href{#method-openai-fine_tuning_jobs_list}{\code{openai$fine_tuning_jobs_list()}}
\item \href{#method-openai-fine_tuning_jobs_retrieve}{\code{openai$fine_tuning_jobs_retrieve()}}
\item \href{#method-openai-fine_tuning_jobs_cancel}{\code{openai$fine_tuning_jobs_cancel()}}
\item \href{#method-openai-fine_tuning_jobs_events}{\code{openai$fine_tuning_jobs_events()}}
\item \href{#method-openai-embeddings}{\code{openai$embeddings()}}
\item \href{#method-openai-clone}{\code{openai$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-new"></a>}}
\if{latex}{\out{\hypertarget{method-openai-new}{}}}
\subsection{Method \code{new()}}{
Initialize the OpenAI API interface with the provided API key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$new(api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_key}}{The OpenAI API key.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-set_proxy"></a>}}
\if{latex}{\out{\hypertarget{method-openai-set_proxy}{}}}
\subsection{Method \code{set_proxy()}}{
Configure the proxy settings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$set_proxy(proxy_ip, proxy_port)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{proxy_ip}}{The IP address of the proxy.}

\item{\code{proxy_port}}{The port number of the proxy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-get_model_list"></a>}}
\if{latex}{\out{\hypertarget{method-openai-get_model_list}{}}}
\subsection{Method \code{get_model_list()}}{
Retrieve a list of available models from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$get_model_list(verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of available models.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-get_model_retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-openai-get_model_retrieve}{}}}
\subsection{Method \code{get_model_retrieve()}}{
Retrieve details of a specific model from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$get_model_retrieve(model, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{The model ID.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Details of the specified model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-get_completions_query"></a>}}
\if{latex}{\out{\hypertarget{method-openai-get_completions_query}{}}}
\subsection{Method \code{get_completions_query()}}{
Get completions for a given prompt using a specific model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$get_completions_query(
  prompt,
  model,
  stream = F,
  ...,
  num = 2,
  verbosity = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{The input text to get completions for.}

\item{\code{model}}{The model to use for generating completions.}

\item{\code{stream}}{A boolean indicating whether to stream the results.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}

\item{\code{num}}{The num parameter controls the number of text entries returned by a stream in one go.
Note that this is different from the n parameter, which specifies the number of results returned.
For detailed information on the n parameter, please refer to OpenAI's API documentation.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Completions based on the input prompt.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-get_chat_completions_query"></a>}}
\if{latex}{\out{\hypertarget{method-openai-get_chat_completions_query}{}}}
\subsection{Method \code{get_chat_completions_query()}}{
Generate conversational completions using chat models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$get_chat_completions_query(
  messages,
  model,
  stream = F,
  ...,
  num = 2,
  verbosity = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{messages}}{A list of message objects, where each message has a role and content.}

\item{\code{model}}{The model to use for generating chat completions.}

\item{\code{stream}}{A boolean indicating whether to stream the results.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}

\item{\code{num}}{The num parameter controls the number of text entries returned by a stream in one go.
Note that this is different from the n parameter, which specifies the number of results returned.
For detailed information on the n parameter, please refer to OpenAI's API documentation.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Completions based on the conversational context.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-files_upload"></a>}}
\if{latex}{\out{\hypertarget{method-openai-files_upload}{}}}
\subsection{Method \code{files_upload()}}{
Upload a file to OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$files_upload(path, purpose = "fine-tune", verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to the file that needs to be uploaded.}

\item{\code{purpose}}{Purpose of the file (e.g., "fine-tune").}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the upload operation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-files_get_list"></a>}}
\if{latex}{\out{\hypertarget{method-openai-files_get_list}{}}}
\subsection{Method \code{files_get_list()}}{
Retrieve a list of files from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$files_get_list(verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of files.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-files_delete"></a>}}
\if{latex}{\out{\hypertarget{method-openai-files_delete}{}}}
\subsection{Method \code{files_delete()}}{
Delete a file from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$files_delete(file_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_id}}{The ID of the file to delete.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the delete operation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-files_retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-openai-files_retrieve}{}}}
\subsection{Method \code{files_retrieve()}}{
Retrieve details of a specific file from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$files_retrieve(file_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_id}}{The ID of the file to retrieve details for.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Details of the specified file.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_create"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_create}{}}}
\subsection{Method \code{fine_tuning_jobs_create()}}{
Create a fine-tuning job in OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_create(
  model,
  training_file,
  n_epochs = 1,
  verbosity = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{The model ID.}

\item{\code{training_file}}{The file used for training.}

\item{\code{n_epochs}}{Number of epochs for the fine-tuning.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the fine-tuning job creation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_list"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_list}{}}}
\subsection{Method \code{fine_tuning_jobs_list()}}{
List fine-tuning jobs from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_list(..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional parameters as required by the OpenAI API.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of fine-tuning jobs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_retrieve}{}}}
\subsection{Method \code{fine_tuning_jobs_retrieve()}}{
Retrieve details of a specific fine-tuning job from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_retrieve(job_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the fine-tuning job.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Details of the specified fine-tuning job.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_cancel"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_cancel}{}}}
\subsection{Method \code{fine_tuning_jobs_cancel()}}{
Cancel a specific fine-tuning job in OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_cancel(job_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the fine-tuning job to cancel.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the cancel operation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_events"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_events}{}}}
\subsection{Method \code{fine_tuning_jobs_events()}}{
Get events related to a specific fine-tuning job from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_events(job_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the fine-tuning job to retrieve events for.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of events related to the specified fine-tuning job.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-embeddings"></a>}}
\if{latex}{\out{\hypertarget{method-openai-embeddings}{}}}
\subsection{Method \code{embeddings()}}{
Compute embeddings for input data using a specified model in OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$embeddings(model, input, verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{The model to use for generating embeddings.}

\item{\code{input}}{Input data to generate embeddings for.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Embeddings for the input data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-clone"></a>}}
\if{latex}{\out{\hypertarget{method-openai-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
