test_that("messages",{
  skip_on_cran()
  Sys.setenv(TEST_EX_COND = "")
  handle_openai<-openai$new(Sys.getenv("OPENAI_KEY"))
  if(Sys.getenv("USE_PROXY")=="TRUE"){
    handle_openai$set_proxy("10.0.108.36",7890)
  }
  thc<-handle_openai$threads$create()
  expect_contains(names(thc),"id")
  train_file_path<-system.file("exdata","assfile.csv", package = "openaistream")
  file_id <- handle_openai$files$upload(path = train_file_path,purpose = "assistants",verbosity = 0)

  mesc<-handle_openai$messages$create(thc$id,role = "user",content = "hello",file_ids=list(file_id$id),verbosity = 3)
  expect_equal(mesc$object,"thread.message")
  mesl<-handle_openai$messages$list(thread_id = thc$id,verbosity = 3)
  expect_contains(mesl$data$id,mesc$id)
  meslf<-handle_openai$messages$file_list(thc$id,mesc$id)
  expect_contains(meslf$data$id,file_id$id)
  mesr<-handle_openai$messages$retrieve(thc$id,mesc$id)
  expect_equal(mesr$object,"thread.message")
  mesrf<-handle_openai$messages$file_retrieve(thc$id,mesc$id,file_id$id)
  expect_equal(mesrf$object,"thread.message.file")
  mesm<-handle_openai$messages$modify(thc$id,mesc$id,metadata=list(test="test"))
  expect_equal(mesm$metadata$test,"test")
  del_res<-handle_openai$files$delete(file_id$id, verbosity = 0)
  expect_true(del_res$deleted)
  thd<-handle_openai$threads$delete(thc$id)
  expect_true(thd$deleted)
  #error test
  mesc<-handle_openai$messages$create(thc$id,role = "user",content = "hello",file_ids=list(file_id$id),verbosity = 4)
  expect_true(!mesc$success)
  mesl<-handle_openai$messages$list(thread_id = thc$id,verbosity = 3)
  expect_true(!mesl$success)
  meslf<-handle_openai$messages$file_list(thc$id,mesc$id)
  expect_true(!meslf$success)
  mesr<-handle_openai$messages$retrieve(thc$id,mesc$id)
  expect_true(!mesr$success)
  mesrf<-handle_openai$messages$file_retrieve(thc$id,mesc$id,file_id$id)
  expect_true(!mesrf$success)
  mesm<-handle_openai$messages$modify(thc$id,mesc$id,metadata=list(test="test"))
  expect_true(!mesm$success)
})
