% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_bbox.R
\name{oc_bbox}
\alias{oc_bbox}
\alias{oc_bbox.numeric}
\alias{oc_bbox.data.frame}
\alias{oc_bbox.bbox}
\title{List of bounding boxes for OpenCage queries}
\usage{
oc_bbox(...)

\method{oc_bbox}{numeric}(xmin, ymin, xmax, ymax, ...)

\method{oc_bbox}{data.frame}(data, xmin, ymin, xmax, ymax, ...)

\method{oc_bbox}{bbox}(bbox, ...)
}
\arguments{
\item{...}{Ignored.}

\item{xmin}{Minimum longitude (also known as \code{min_lon}, \code{southwest_lng},
\code{west}, or \code{left}).}

\item{ymin}{Minimum latitude (also known as \code{min_lat}, \code{southwest_lat},
\code{south}, or \code{bottom}).}

\item{xmax}{Maximum longitude (also known as \code{max_lon}, \code{northeast_lng},
\code{east}, or \code{right}).}

\item{ymax}{Maximum latitude (also known as \code{max_lat}, \code{northeast_lat},
\code{north}, or \code{top}).}

\item{data}{A \code{data.frame} containing at least 4 columns with \code{xmin}, \code{ymin},
\code{xmax}, and \code{ymax} values, respectively.}

\item{bbox}{A \code{bbox} object, see \code{sf::st_bbox}.}
}
\value{
A list of bounding boxes, each of class \code{bbox}.
}
\description{
Create a list of bounding boxes for OpenCage queries.
}
\examples{
oc_bbox(-5.63160, 51.280430, 0.278970, 51.683979)

xdf <-
  data.frame(
    place = c("Hamburg", "Hamburg"),
    northeast_lat = c(54.0276817, 42.7397729),
    northeast_lng = c(10.3252805, -78.812825),
    southwest_lat = c(53.3951118, 42.7091669),
    southwest_lng = c(8.1053284, -78.860521)
  )
oc_bbox(
  xdf,
  southwest_lng,
  southwest_lat,
  northeast_lng,
  northeast_lat
)

# create bbox list column with dplyr
library(dplyr)
xdf \%>\%
  mutate(
    bbox =
      oc_bbox(
        southwest_lng,
        southwest_lat,
        northeast_lng,
        northeast_lat
      )
  )

# create bbox list from a simple features bbox
if (requireNamespace("sf", quietly = TRUE)) {
  library(sf)
  bbox <- st_bbox(c(xmin = 16.1, xmax = 16.6, ymax = 48.6, ymin = 47.9),
    crs = 4326
  )
  oc_bbox(bbox)
}

}
