% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-mail_me.R
\docType{data}
\name{mail_me}
\alias{mail_me}
\title{Influence of a Good Mood on Helpfulness}
\format{
A data frame with 42 observations on the following 4 variables.
\describe{ \item{stamped}{a factor with levels \code{no} \code{yes}}
\item{found_coin}{a factor with levels \code{coin} \code{no_coin}}
\item{gender}{a factor with levels \code{female} \code{male}}
\item{mailed_letter}{a factor with levels \code{no} \code{yes}} }
}
\source{
Levin PF, Isen AM. 1975. Studies on the Effect of Feeling Good on
Helping. Sociometry 31(1), p141-147.
}
\usage{
mail_me
}
\description{
This study investigated whether finding a coin influenced a person's
likelihood of mailing a sealed but addressed letter that appeared to have
been accidentally left in a conspicuous place. Several variables were
collected during the experiment, including two randomized variables of
whether there was a coin to be found and whether the letter already had a
stamp on it.
}
\details{
The precise context was in a phone booth (this study is from the 1970s!),
where a person who entered a phone booth would find a dime in the phone
tray, which would be sufficient to pay for their phone call. There was also
a letter next to the phone, which sometimes had a stamp on it.
}
\examples{


table(mail_me)
(x <- table(mail_me[, c("mailed_letter", "found_coin")]))
chisq.test(x)

(x <- table(mail_me[, c("mailed_letter", "stamped")]))
chisq.test(x)

m <- glm(mailed_letter ~ stamped + found_coin + gender,
    data = mail_me,
    family = binomial)
summary(m)


}
\keyword{datasets}
