% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber.R
\name{register_plumber_metrics}
\alias{register_plumber_metrics}
\title{Metrics for Plumber APIs}
\usage{
register_plumber_metrics(app, registry = global_registry())
}
\arguments{
\item{app}{A Plumber router object.}

\item{registry}{A \code{Registry} object. See \code{\link[=registry]{registry()}}.}
}
\value{
A modified Plumber router.
}
\description{
Automatically wrap a Plumber API app, adding metrics for HTTP request count
and duration, and then expose them on a \verb{/metrics} endpoint.

The endpoint will check the \code{METRICS_HTTP_AUTHORIZATION} environment
variable, and if present will use it as the expected
\href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Authorization}{\code{Authorization}}
header of the request to the \verb{/metrics} endpoint. This can be used to
implement basic HTTP authentication for access to runtime metrics.
}
\examples{
if (requireNamespace("plumber", quietly = TRUE)) {
  app <- plumber::plumber$new() # Normally this is plumber::plumb().
  app <- register_plumber_metrics(app)
\dontrun{
  app$run()
}
}
}
