% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-geocode.R
\name{otp_geocode}
\alias{otp_geocode}
\title{Use OTP Geo-coder to find a location}
\usage{
otp_geocode(
  otpcon = NULL,
  query = NULL,
  autocomplete = FALSE,
  stops = TRUE,
  clusters = FALSE,
  corners = TRUE,
  type = "SF"
)
}
\arguments{
\item{otpcon}{OTP connection object produced by otp_connect()}

\item{query}{Character, The query string we want to geocode}

\item{autocomplete}{logical Whether we should use the query
string to do a prefix match, default FALSE}

\item{stops}{Logical, Search for stops, either by name or
stop code, default TRUE}

\item{clusters}{Logical, Search for clusters by their name,
default FALSE}

\item{corners}{Logical, Search for street corners using at
least one of the street names, default TRUE}

\item{type}{Character, How should results be returned can
be "SF" or "Coordinates" or "Both", Default "SF"}
}
\value{
Returns a data.frame of SF POINTS or Coordinates of all
    the locations that match `query`
}
\description{
Geo-coding converts a named place, such as a street name into a
     lng/lat pair.
}
\details{
OTP will return a maximum of 10 results
}
\examples{
\dontrun{
locations <- otp_geocode(otpcon, "High Street")
}
}
\seealso{
Other routing: 
\code{\link{otp_isochrone}()},
\code{\link{otp_plan}()},
\code{\link{otp_routing_options}()},
\code{\link{otp_validate_routing_options}()}
}
\concept{routing}
