% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_remove_filter}
\alias{wb_remove_filter}
\title{Remove a worksheet filter}
\usage{
wb_remove_filter(wb, sheet = current_sheet())
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A vector of names or indices of worksheets}
}
\description{
Removes filters from wb_add_filter() and write_data()
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2")
wb$add_worksheet("Sheet 3")

wb$add_data(1, iris)
wb_add_filter(wb, 1, row = 1, cols = seq_along(iris))

## Equivalently
wb$add_data(2, x = iris, withFilter = TRUE)

## Similarly
wb$add_data_table(3, iris)

## remove filters
wb_remove_filter(wb, 1:2) ## remove filters
wb_remove_filter(wb, 3) ## Does not affect tables!
}
