% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_protect}
\alias{wb_protect}
\title{Protect a workbook from modifications}
\usage{
wb_protect(
  wb,
  protect = TRUE,
  password = NULL,
  lock_structure = FALSE,
  lock_windows = FALSE,
  type = 1,
  file_sharing = FALSE,
  username = unname(Sys.info()["user"]),
  read_only_recommended = FALSE,
  ...
)
}
\arguments{
\item{wb}{A workbook object}

\item{protect}{Whether to protect or unprotect the sheet (default=TRUE)}

\item{password}{(optional) password required to unprotect the workbook}

\item{lock_structure}{Whether the workbook structure should be locked}

\item{lock_windows}{Whether the window position of the spreadsheet should be
locked}

\item{type}{Lock type (see details)}

\item{file_sharing}{Whether to enable a popup requesting the unlock password
is prompted}

\item{username}{The username for the \code{fileSharing} popup}

\item{read_only_recommended}{Whether or not a post unlock message appears
stating that the workbook is recommended to be opened in readonly mode.}

\item{...}{additional arguments}
}
\description{
Protect or unprotect a workbook from modifications by the user in the
graphical user interface. Replaces an existing protection.
}
\details{
Lock types:

\describe{
\item{\code{1} }{xlsx with password (default)}
\item{\code{2} }{xlsx recommends read-only}
\item{\code{4} }{xlsx enforces read-only}
\item{\code{8} }{xlsx is locked for annotation}
}
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("S1")
wb_protect(wb, protect = TRUE, password = "Password", lockStructure = TRUE)

# Remove the protection
wb_protect(wb, protect = FALSE)

wb <- wb_protect(
  wb,
  protect = TRUE,
  password = "Password",
  lockStructure = TRUE,
  type = 2L,
  fileSharing = TRUE,
  username = "Test",
  readOnlyRecommended = TRUE
)

}
