% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R,
%   R/get-named-regions.R
\name{named_region-wb}
\alias{named_region-wb}
\alias{wb_add_named_region}
\alias{wb_remove_named_region}
\alias{wb_get_named_regions}
\title{Modify named regions in a worksheet}
\usage{
wb_add_named_region(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  name,
  local_sheet = FALSE,
  overwrite = FALSE,
  comment = NULL,
  hidden = NULL,
  custom_menu = NULL,
  description = NULL,
  is_function = NULL,
  function_group_id = NULL,
  help = NULL,
  local_name = NULL,
  publish_to_server = NULL,
  status_bar = NULL,
  vb_procedure = NULL,
  workbook_parameter = NULL,
  xml = NULL,
  ...
)

wb_remove_named_region(wb, sheet = current_sheet(), name = NULL)

wb_get_named_regions(wb, tables = FALSE, x = NULL)
}
\arguments{
\item{wb}{A Workbook object}

\item{sheet}{A name or index of a worksheet}

\item{dims}{Worksheet cell range of the region ("A1:D4").}

\item{name}{Name for region. A character vector of length 1. Note that region
names must be case-insensitive unique.}

\item{local_sheet}{If \code{TRUE} the named region will be local for this sheet}

\item{overwrite}{Boolean. Overwrite if exists? Default to \code{FALSE}.}

\item{comment}{description text for named region}

\item{hidden}{Should the named region be hidden?}

\item{custom_menu, description, is_function, function_group_id, help, local_name, publish_to_server, status_bar, vb_procedure, workbook_parameter, xml}{Unknown XML feature}

\item{...}{additional arguments}

\item{tables}{Should included both data tables and named regions in the result?}

\item{x}{Deprecated. Use \code{wb}. For Excel input use \code{\link[=wb_load]{wb_load()}} to first load
the xlsx file as a workbook.}
}
\value{
A workbook, invisibly.

A data frame with the all named regions in \code{wb}. Or \code{NULL}, if none are found.
}
\description{
Create / delete a named region. You can also specify a named region by using
the \code{name} argument in \code{wb_add_data(x = iris, name = "my-region")}.
It is important to note that named regions are not case-sensitive and must be unique.
}
\details{
You can use the \code{\link[=wb_dims]{wb_dims()}} helper to specify the cell range of the named region
}
\examples{
## create named regions
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")

## specify region
wb$add_data(x = iris, start_col = 1, start_row = 1)
wb$add_named_region(
  name = "iris",
  dims = wb_dims(x = iris)
)

## using add_data 'name' argument
wb$add_data(sheet = 1, x = iris, name = "iris2", start_col = 10)

## delete one
wb$remove_named_region(name = "iris2")
wb$get_named_regions()
## read named regions
df <- wb_to_df(wb, named_region = "iris")
head(df)


# Extract named regions from a file
out_file <- temp_xlsx()
wb_save(wb, out_file, overwrite = TRUE)

# Load the file as a workbook first, then get named regions.
wb1 <- wb_load(out_file)
wb1$get_named_regions()

}
\seealso{
\code{\link[=wb_get_tables]{wb_get_tables()}}

Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}
}
\concept{worksheet content functions}
