% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solution_statistics.R
\name{solution_statistics}
\alias{solution_statistics}
\title{Solution statistics}
\usage{
solution_statistics(x, solution)
}
\arguments{
\item{x}{project prioritization \code{\link[=problem]{problem()}}.}

\item{solution}{\code{\link[base:data.frame]{base::data.frame()}} or
\code{\link[tibble:tibble]{tibble::tibble()}} table containing the solutions. Here,
rows correspond to different solutions and columns correspond to
different actions. Each column in the argument to \code{solution} should
be named according to a different action in \code{x}.
Cell values indicate if an action is funded in a given solution or not,
and should be either zero or one. Arguments to \code{solution} can
contain additional columns, and they will be ignored.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} table containing the following
columns:

\describe{

\item{\code{"cost"}}{\code{numeric} cost of each solution.}

\item{\code{"obj"}}{\code{numeric} objective value for each solution.
This is calculated using the objective function defined for the
argument to \code{x}.}

\item{\code{x$project_names()}}{\code{numeric} column for each
project indicating if it was completely funded (with a value of 1)
or not (with a value of 0).}

\item{\code{x$feature_names()}}{\code{numeric} column for each
feature indicating the probability that it will persist into
the future given each solution.}

}
}
\description{
Calculate statistics describing a solution to a project prioritization
\code{\link[=problem]{problem()}}.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# print project data
print(sim_projects)

# print action data
print(sim_features)

# print feature data
print(sim_actions)

# build problem
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 400) \%>\%
     add_feature_weights("weight") \%>\%
     add_binary_decisions()

# print problem
print(p)

# create a table with some solutions
solutions <- data.frame(F1_action =       c(0, 1, 1),
                        F2_action =       c(0, 1, 0),
                        F3_action =       c(0, 1, 1),
                        F4_action =       c(0, 1, 0),
                        F5_action =       c(0, 1, 1),
                        baseline_action = c(1, 1, 1))

# print the solutions
# the first solution only has the baseline action funded
# the second solution has every action funded
# the third solution has only some actions funded
print(solutions)

# calculate statistics
solution_statistics(p, solutions)
}
\seealso{
\link{objectives}, \code{\link[=replacement_costs]{replacement_costs()}},
\code{\link[=project_cost_effectiveness]{project_cost_effectiveness()}}.
}
