% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_change}
\alias{plot_change}
\title{Plot the change in the distribution of X}
\usage{
plot_change(x, plot.vars = "sig", graph.col = c("red", "blue"),
  alpha = 0.05, line.type = c(1, 2), n.val = 10)
}
\arguments{
\item{x}{an optint object.}

\item{plot.vars}{which variables to plot? either a number (n) -
indicating to plot the first n variables,
"sig" (default) - plot only significant  variables, or a vector
 with names of variables to plot.}

\item{graph.col}{graph color/s.}

\item{alpha}{significance level for the confidence intervals. also
used in order to determine which variables are significant.}

\item{line.type}{line type for \code{\link[lattice]{densityplot}}}

\item{n.val}{variable with more values than 'n.val' will be displayed by
density plot, while variable with fewer values will be
displayed by barchart.}
}
\description{
Illustrates how the intervention changes the distribution of X by plotting
barchart (for categorical variables) or denisty plot (for continouous variables),
before and after the intervention.
}
\examples{
# generate data
n <- 50
p <- 3
features <- matrix(rnorm(n*p), ncol = p)
men <- matrix(rbinom(n, 1, 0.5), nrow = n)
outcome <- 2*(features[,1] > 1) + men*pmax(features[,2], 0) + rnorm(n)
outcome <- as.vector(outcome)

#find the optimal intervention using the non-parametric method:
imp_feat <- optint(Y = outcome, X = features, control = men,
                   method = "non-parametric", lambda = 10, plot = TRUE,
                   n.boot = 100, n.perm = 100)

#we can look on the new features distribution more deeply, using plot_change():
plot_change(imp_feat, plot.vars = "sig")
}
