% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{sim_ordbeta}
\alias{sim_ordbeta}
\title{Power Calculation via Simulation of the Ordered Beta Regression Model}
\usage{
sim_ordbeta(
  N = 1000,
  k = 5,
  iter = 1000,
  cores = 1,
  phi = 1,
  cutpoints = c(-1, 1),
  beta_coef = NULL,
  beta_type = "continuous",
  treat_assign = 0.5,
  return_data = FALSE,
  seed = as.numeric(Sys.time()),
  ...
)
}
\arguments{
\item{N}{The sample size for the simulation. Include a vector of integers
to examine power/results for multiple sample sizes.}

\item{k}{The number of covariates/predictors.}

\item{iter}{The number of simulations to run. For power calculation,
should be at least 500 (yes, this will take some time).}

\item{cores}{The number of cores to use to parallelize the simulation.}

\item{phi}{Value of the dispersion parameter in the beta distribution.}

\item{cutpoints}{Value of the two cutpoints for the ordered model.
By default are the values -1 and +1 (these are interpreted in the
logit scale and so should not be too large). The farther apart,
the fewer degenerate (0 or 1) responses there will be in the distribution.}

\item{beta_coef}{If not null, a vector of length \code{k} of the true
predictor coefficients/treatment values to use for the simulation.
Otherwise, coefficients are drawn from a random uniform distribution
from -1 to 1 for each predictor.}

\item{beta_type}{Can be either \code{continuous} or \code{binary}. Use the latter
for conventional treatments with two values.}

\item{treat_assign}{If \code{beta_type} is set to \code{binary},
you can use this parameter to set the proportion
of \code{N} assigned to treatment. By default,
the parameter is set to 0.5 for
equal/balanced treatment control groups.}

\item{return_data}{Whether to return the simulated dqta as a list
in the \code{data} column of the returned data frame.}

\item{seed}{The seed to use to make the results reproducible. Set
automatically to a date-time stamp.}

\item{...}{Any other arguments are passed on to the \link[brms:brm]{brms::brm} function
to control modeling options.}
}
\value{
a tibble data frame with columns of simulated and estimated values and
rows for each simulation iteration X coefficient combination. I.e.,
if there are five predictors, and 1,000 iterations, the resulting data frame
will have 1,000 rows. If there are multiple values for \code{N},
then each value
of \code{N} will have its own set of iterations, making the final size of the
data a multiple of the number of sample sizes to iterate over. The
data frame will have the following columns:
1.
}
\description{
This function allows you to calculate power curves (or anything else)
via simulating the ordered beta regression model.
}
\details{
This function implements the simulation found in Kubinec (2022). This
simulation allows you to vary the sample size, number & type of predictors,
values of the predictors (or treatment values), and the power to target.
The function returns a data frame
with one row per simulation draw and covariate \code{k}.
}
\examples{
# This function takes a while to run as it has
# to fit an ordered beta regression to each
# draw. The package comes with a saved
# simulation dataset you can inspect to see what the
# result looks like

data("sim_data")

library(dplyr)

# will take a while to run this
\donttest{
    sim_data <- sim_ordbeta(N=c(250,750),
    k=1,
    beta_coef = .5,
    iter=5,cores=2,
    beta_type="binary",
    treat_assign=0.3)

}

# to get the power values by N, simply summarize/group
# by N with functions from the R package dplyr

sim_data \%>\%
  group_by(N) \%>\%
  summarize(mean_power=mean(power))


}
