% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bundle.R
\name{orderly_bundle_pack}
\alias{orderly_bundle_pack}
\alias{orderly_bundle_run}
\alias{orderly_bundle_import}
\alias{orderly_bundle_list}
\title{Pack and run orderly "bundles"}
\usage{
orderly_bundle_pack(
  path,
  name,
  parameters = NULL,
  envir = NULL,
  root = NULL,
  locate = TRUE,
  message = NULL,
  instance = NULL,
  remote = NULL,
  tags = NULL
)

orderly_bundle_run(path, workdir = tempfile(), echo = TRUE, envir = NULL)

orderly_bundle_import(path, root = NULL, locate = TRUE)

orderly_bundle_list(path)
}
\arguments{
\item{path}{A path, whose interpretation depends on the function:

\describe{

\item{\code{orderly_bundle_pack}}{A directory to save bundles to.  If
  it does not exist it will be created for you.}

\item{\code{orderly_bundle_run}}{The path to the packed bundle (a zip
  file created by \code{orderly_bundle_pack})}

\item{\code{orderly_bundle_import}}{The path to unpack and import
  (a zip file created by \code{orderly_bundle_run})}

\item{\code{orderly_bundle_list}}{The path to a directory that might
  contain either incomplete or complete bundles (created by either
  \code{orderly_bundle_pack} or \code{orderly_bundle_run})}

}}

\item{name}{Name of the report to pack (see
\code{\link{orderly_list}}).  A leading \code{src/} will be
removed if provided, allowing easier use of autocomplete.}

\item{parameters}{Parameters passed to the report. A named list of
parameters declared in the \code{orderly.yml}.  Each parameter
must be a scalar character, numeric, integer or logical.}

\item{envir}{The parent of the environment that will be used to
evaluate the report script; by default a new environment will be
made with the global environment as the parent.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{message}{An optional character string containing a message
explaining why the report was run}

\item{instance}{Select instance of the source database to be used,
where multiple instances are configured.  Use a single
\emph{unnamed} character string to indicate an instance to
match.  If given, then this name must be present in all
databases where instances are listed in
\code{orderly_config.yml}, and will be ignored by all database
where instances are not given.  See the "orderly" vignette for
further information.}

\item{remote}{Remote to use to resolve dependencies.  Use this in
order to run a report with the same dependencies as are
available on a remote server, particularly when using \code{id =
"latest"}.  Note that this is not the same as running
\code{\link{orderly_pull_dependencies}}, then \code{orderly_run}
with \code{remote = NULL}, as the pull/run approach will use the
latest report in \emph{your} archive but the \code{remote =
"remote"} approach will use the latest approach in the
\emph{remote} archive (which might be less recent).}

\item{tags}{Character vector of tags to add to the report.  Tags
are immutable and cannot be removed once the report is run.
Tags added here will be \emph{in addition} to any tags listed in
the \code{tags:} field in \code{orderly.yml} and must be present
in \code{orderly_config.yml}.}

\item{workdir}{The path in which to run bundles.  If it does not
exist it will be created for you.  The completed bundle will be
saved in this directory as \code{<id>.zip}.}

\item{echo}{Print the result of running the R code to the console}
}
\value{
For \code{orderly_bundle_pack} and
  \code{orderly_bundle_run}, a list with elements \code{path} (the
  path to the bundle) and \code{id} (its orderly id).  For
  \code{orderly_bundle_list} a data.frame with key information
  about the report in the bundles (id, name, parameters, status,
  time).  The function \code{orderly_bundle_import} is called for
  its side effect only and does not return anything useful.
}
\description{
Pack up and run orderly reports to run elsewhere. By using these
functions you can safely copy all requirements of an orderly
report into a portable archive and run them on another machine
(perhaps a cluster or HPC), then import the completed archive into
your orderly tree. There is considerable overhead to using these
functions (mostly due to transport costs) so they are intended
primarily for very computationally demanding patterns.
}
\examples{
path <- orderly::orderly_example("minimal")

# A working directory to export bundles to:
workdir <- tempfile()

# Pack up the "example" report to go:
res <- orderly::orderly_bundle_pack(workdir, "example", root = path)

# The return value is a list with the id and the path to the zip
# file created:
res

# A list of reports bundled in this directory and their status
orderly::orderly_bundle_list(workdir)

# Run the bundle (this would ordinarily be done on another computer)
zip <- orderly::orderly_bundle_run(res$path, workdir)
zip

# The status has now been updated to reflect the status
orderly::orderly_bundle_list(workdir)

# We can import this into the orderly tree
orderly::orderly_bundle_import(zip$path, root = path)

# This has now been included in your orderly archive and the
# workdir can be safely deleted
unlink(workdir, recursive = TRUE)
orderly::orderly_list_archive(path)
}
