% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalNet-methods.R
\name{predict.ordinalNet}
\alias{predict.ordinalNet}
\title{Predict method for an "ordinalNet" object}
\usage{
\method{predict}{ordinalNet}(object, newx = NULL, whichLambda = NULL,
  criteria = c("aic", "bic"), type = c("response", "class", "link"), ...)
}
\arguments{
\item{object}{An "ordinalNet" S3 object.}

\item{newx}{Optional covariate matrix. If NULL, fitted values will be obtained
for the training data, as long as the model was fit with the argument
\code{keepTrainingData=TRUE}.}

\item{whichLambda}{Optional index number of the desired lambda value within
the solution path sequence.}

\item{criteria}{Selects the best lambda value by AIC or BIC. Only used
if \code{whichLambda=NULL}.}

\item{type}{The type of prediction required.  Type "response" returns a
matrix of fitted probabilities. Type "class" returns a vector containing the
class number with the highest fitted probability. Type "link" returns a
matrix of linear predictors.}

\item{...}{Not used. Additional predict arguments.}
}
\value{
The object returned depends on \code{type}.
}
\description{
Obtains predicted probabilities, predicted class, or linear predictors.
}
