% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{ore.search}
\alias{[.orematch}
\alias{is.orematch}
\alias{is_orematch}
\alias{ore.search}
\alias{ore_search}
\alias{orematch}
\alias{print.orematch}
\title{Search for matches to a regular expression}
\usage{
ore.search(regex, text, all = FALSE, start = 1L, simplify = TRUE)

is.orematch(x)

\method{[}{orematch}(x, i, j, ...)

\method{print}{orematch}(x, lines = NULL, context = NULL, width = NULL,
  ...)
}
\arguments{
\item{regex}{A single character string or object of class \code{"ore"}. In
the former case, this will first be passed through \code{\link{ore}}.}

\item{text}{A vector of strings to match against.}

\item{all}{If \code{TRUE}, then all matches within each element of
\code{text} will be found. Otherwise, the search will stop at the first
match.}

\item{start}{An optional vector of offsets (in characters) at which to start
searching. Will be recycled to the length of \code{text}.}

\item{simplify}{If \code{TRUE}, an object of class \code{"orematch"} will
be returned if \code{text} is of length 1. Otherwise, a list of such
objects will always be returned.}

\item{x}{An R object.}

\item{i}{For indexing into an \code{"orematch"} object, the match number.}

\item{j}{For indexing into an \code{"orematch"} object, the group number.}

\item{...}{Ignored.}

\item{lines}{The maximum number of lines to print. If \code{NULL}, this
defaults to the value of the \code{"ore.lines"} option, or 0 if that is
unset or invalid. Zero means no limit.}

\item{context}{The number of characters of context to include either side
of each match. If \code{NULL}, this defaults to the value of the
\code{"ore.context"} option, or 30 if that is unset or invalid.}

\item{width}{The number of characters in each line of printed output. If
\code{NULL}, this defaults to the value of the standard \code{"width"}
option.}
}
\value{
For \code{ore.search}, an \code{"orematch"} object, or a list of
  the same, each with elements
    \item{text}{A copy of the \code{text} element for the current match.}
    \item{nMatches}{The number of matches found.}
    \item{offsets}{The offsets (in characters) of each match.}
    \item{byteOffsets}{The offsets (in bytes) of each match.}
    \item{lengths}{The lengths (in characters) of each match.}
    \item{byteLengths}{The lengths (in bytes) of each match.}
    \item{matches}{The matched substrings.}
    \item{groups}{Equivalent metadata for each parenthesised subgroup in
      \code{regex}, in a series of matrices. If named groups are present in
      the regex then \code{dimnames} will be set appropriately.}
  For \code{is.orematch}, a logical vector indicating whether the specified
  object has class \code{"orematch"}. For extraction with one index, a
  vector of matched substrings. For extraction with two indices, a vector
  or matrix of substrings corresponding to captured groups.
}
\description{
Search a character vector for one or more matches to an Oniguruma-compatible
regular expression. The result is of class \code{"orematch"}, for which
printing and indexing methods are available.
}
\note{
Only named *or* unnamed groups will currently be captured, not both. If
there are named groups in the pattern, then unnamed groups will be ignored.

By default the \code{print} method uses the \code{crayon} package (if it is
available) to determine whether or not the R terminal supports colour.
Alternatively, colour printing may be forced or disabled by setting the
\code{"ore.colour"} (or \code{"ore.color"}) option to a logical value.
}
\examples{
# Pick out pairs of consecutive word characters
match <- ore.search("(\\\\w)(\\\\w)", "This is a test", all=TRUE)

# Find the second matched substring ("is", from "This")
match[2]

# Find the content of the second group in the second match ("s")
match[2,2]
}
\seealso{
\code{\link{ore}} for creating regex objects; \code{\link{matches}}
and \code{\link{groups}} for an alternative to indexing for extracting
matching substrings.
}

