% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srow_x.R, R/zzz_niftiImage.R
\docType{methods}
\name{srow_x-methods}
\alias{srow_x-methods}
\alias{srow_x-methods,}
\alias{srow_x}
\alias{srow_x,nifti-method}
\alias{srow_x<-}
\alias{srow_x<-,nifti-method}
\alias{srow.x}
\alias{srow.x,nifti-method}
\alias{srow.x<-}
\alias{srow.x<-,nifti-method}
\alias{srow_x,niftiImage-method}
\alias{srow_x<-,niftiImage-method}
\title{Extract Image Attribute \code{srow_x}}
\usage{
srow_x(object)

\S4method{srow_x}{nifti}(object)

srow_x(object) <- value

\S4method{srow_x}{nifti}(object) <- value

srow.x(object)

\S4method{srow.x}{nifti}(object)

srow.x(object) <- value

\S4method{srow.x}{nifti}(object) <- value

\S4method{srow_x}{niftiImage}(object)

\S4method{srow_x}{niftiImage}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{srow_x} field.}
}
\description{
Methods that act on the \code{srow_x} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
file = system.file("extdata", "example.nii.gz", package = "RNifti")
img = RNifti::readNifti(file)
srow_x(img)
srow_x(img) = rep(0, 4)
stopifnot(srow_x(img) == rep(0, 4))

srow_y(img)
srow_y(img) = rep(0, 4)
stopifnot(srow_y(img) == rep(0, 4))

srow_z(img)
srow_z(img) = rep(0, 4)
stopifnot(srow_z(img) == rep(0, 4))
}
\references{
ANALYZE 7.5\cr
\url{http://eeg.sourceforge.net/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
