% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthoDr_surv.r
\name{orthoDr_surv}
\alias{orthoDr_surv}
\title{IR-CP model}
\usage{
orthoDr_surv(x, y, censor, method = "dm", ndr = ifelse(method == "forward",
  1, 2), B.initial = NULL, bw = NULL, keep.data = FALSE,
  control = list(), maxitr = 500, verbose = FALSE, ncore = 0)
}
\arguments{
\item{x}{A matrix or data.frame for features. The algorithm will not scale the columns to unit variance}

\item{y}{A vector of observed time}

\item{censor}{A vector of censoring indicator}

\item{method}{Which estimating equation to use: should be  \code{forward} (1-d model), \code{dn} (counting process) or \code{dm} (martingale)}

\item{ndr}{The number of directions}

\item{B.initial}{Initial \code{B} values. Will use the counting process based SIR model \link[orthoDr]{CP_SIR} as the initial if leaving as \code{NULL}.
If specified, must be a matrix with \code{ncol(x)} rows and \code{ndr} columns. Will be processed by Gram-Schmidt if not orthogonal}

\item{bw}{A Kernel bandwidth, assuming each variables have unit variance}

\item{keep.data}{Should the original data be kept for prediction. Default is \code{FALSE}}

\item{control}{A list of tuning variables for optimization. \code{epsilon} is the size for numerically approximating the gradient. For others, see Wen and Yin (2013).}

\item{maxitr}{Maximum number of iterations}

\item{verbose}{Should information be displayed}

\item{ncore}{Number of cores for parallel computing. The default is the maximum number of threads.}
}
\value{
A \code{orthoDr} object; a list consisting of
\item{B}{The optimal \code{B} value}
\item{fn}{The final functional value}
\item{itr}{The number of iterations}
\item{converge}{convergence code}
}
\description{
The counting process based semiparametric dimension reduction (IR-CP) model for right censored survival outcome.
}
\examples{
# This is setting 1 in Sun et. al. (2017) with reduced sample size
library(MASS)
set.seed(1)
N = 200; P = 6
V=0.5^abs(outer(1:P, 1:P, "-"))
dataX = as.matrix(mvrnorm(N, mu=rep(0,P), Sigma=V))
failEDR = as.matrix(c(1, 0.5, 0, 0, 0, rep(0, P-5)))
censorEDR = as.matrix(c(0, 0, 0, 1, 1, rep(0, P-5)))
T = rexp(N, exp(dataX \%*\% failEDR))
C = rexp(N, exp(dataX \%*\% censorEDR - 1))
ndr = 1
Y = pmin(T, C)
Censor = (T < C)

# fit the model
forward.fit = orthoDr_surv(dataX, Y, Censor, method = "forward")
distance(failEDR, forward.fit$B, "dist")

dn.fit = orthoDr_surv(dataX, Y, Censor, method = "dn", ndr = ndr)
distance(failEDR, dn.fit$B, "dist")

dm.fit = orthoDr_surv(dataX, Y, Censor, method = "dm", ndr = ndr)
distance(failEDR, dm.fit$B, "dist")
}
\references{
Sun, Q., Zhu, R., Wang, T. and Zeng, D. "Counting Process Based Dimension Reduction Method for Censored Outcomes." (2017)
DOI: \url{https://arxiv.org/abs/1704.05046}.

Wen, Z. and Yin, W., "A feasible method for optimization with orthogonality constraints." Mathematical Programming 142.1-2 (2013): 397-434.
DOI: \url{https://doi.org/10.1007/s10107-012-0584-1}
}
