% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gen_solver}
\alias{gen_solver}
\title{General solver \code{C++} function}
\usage{
gen_solver(
  B,
  f,
  g,
  env,
  useg,
  rho,
  eta,
  gamma,
  tau,
  epsilon,
  btol,
  ftol,
  gtol,
  maxitr,
  verbose
)
}
\arguments{
\item{B}{A matrix of the parameters \code{B}, the columns are subject to the orthogonality constraint}

\item{f}{A function that calculates the objective function value. The first argument should be \code{B}. Returns a single value.}

\item{g}{A function that calculates the gradient. The first argument should be \code{B}. Returns a matrix with the same dimension as \code{B}. If not specified, then the numerical approximation is used.}

\item{env}{Environment passed to the Rcpp function for evaluating \code{f} and \code{g}}

\item{useg}{If true, the gradient is calculated using \code{g} function, otherwise numerically approximated}

\item{rho}{(don't change) Parameter for control the linear approximation in line search}

\item{eta}{(don't change) Factor for decreasing the step size in the backtracking line search}

\item{gamma}{(don't change) Parameter for updating C by Zhang and Hager (2004)}

\item{tau}{(don't change) Step size for updating}

\item{epsilon}{(don't change) Parameter for approximating numerical gradient, if \code{g} is not given.}

\item{btol}{(don't change) The \code{$B$} parameter tolerance level}

\item{ftol}{(don't change) Functional value tolerance level}

\item{gtol}{(don't change) Gradient tolerance level}

\item{maxitr}{Maximum number of iterations}

\item{verbose}{Should information be displayed}
}
\description{
A general purpose optimization solver with orthogonality constraint. For details, please see the original \code{MATLAB} code by Wen and Yin (2013). This is an internal function and should not be called directly.
}
\examples{
# This function should be called internally. When having all objects pre-computed, one can call
# gen_solver(B, f, g, env, useg, rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose)
# to solve for the parameters B.
}
\references{
Wen, Z., & Yin, W. (2013). A feasible method for optimization with orthogonality constraints.
Mathematical Programming, 142(1), 397-434.
DOI: \doi{10.1007/s10107-012-0584-1}

Zhang, H., & Hager, W. W. (2004). A nonmonotone line search technique and its application to unconstrained optimization.
SIAM journal on Optimization, 14(4), 1043-1056.
DOI: \doi{10.1137/S1052623403428208}
}
\keyword{internal}
