% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visu.R
\name{oscar.binplot}
\alias{oscar.binplot}
\title{Visualize binary indicator matrix optionally coupled with cross-validation performance for oscar models}
\usage{
oscar.binplot(
  fit,
  cv,
  kmax,
  collines = TRUE,
  rowlines = TRUE,
  cex.axis = 0.6,
  heights = c(0.2, 0.8),
  ...
)
}
\arguments{
\item{fit}{Fitted oscar S4-class object}

\item{cv}{Matrix produced by oscar.cv; rows are cv-folds, cols are k-values}

\item{kmax}{Maximum cardinality 'k'}

\item{collines}{Should vertical lines be drawn to bottom part}

\item{rowlines}{Should horizontal lines be drawn to highlight variables}

\item{cex.axis}{Axis magnification}

\item{heights}{Paneling proportions as a numeric vector of length 2}

\item{...}{Additional parameters passed on to hamlet::hmap}
}
\value{
This is a plotting function that does not return anything, but instead draws on a new graphics device.
}
\description{
This visualization function makes use of the sparsified beta-coefficient matrix form as a function of cardinality. Optionally, user may showcase cross-validation performance alongside at the same cardinality values.
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  fit_cv <- oscar.cv(fit, fold = 10, seed = 123)
  oscar.binplot(fit=fit, cv=fit_cv)
}
}
