% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{oscar.pareto}
\alias{oscar.pareto}
\title{Retrieve a set of pareto-optimal points for an oscar-model based on model goodness-of-fit or cross-validation}
\usage{
oscar.pareto(fit, cv, xval = "cost", weak = FALSE, summarize = mean)
}
\arguments{
\item{fit}{Fit oscar S4-object}

\item{cv}{A cross-validation matrix as produced by oscar.cv; if CV is not provided, then goodness-of-fit from fit object itself is used rather than cross-validation generalization metric}

\item{xval}{The x-axis to construct pareto front based on; by default 'cost' vector for features/kits, can also be 'cardinality'/'k'}

\item{weak}{If weak pareto-optimality is allowed; by default FALSE.}

\item{summarize}{Function that summarizes over cross-validation folds; by default, this is the mean over the k-folds.}
}
\value{
A data.frame containing points and indices at which pareto optimal points exist
}
\description{
This function retrieves the set of pareto optimal points for an oscar model fit in n-proportional time as cardinality axis is readily sorted. It is advisable to optimize model generalization (via cross-validation) rather than mere goodness-of-fit.
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  fit_cv <- oscar.cv(fit, fold=10)
  oscar.pareto(fit, cv=fit_cv)
}

}
