% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osf_id.R
\name{as_id}
\alias{as_id}
\title{Extract OSF identifiers}
\usage{
as_id(x)
}
\arguments{
\item{x}{An \code{osf_tbl}, OSF URL, or a generic string containing a GUID or
Waterbutler ID.}
}
\value{
A character vector with class \code{osf_id}.
}
\description{
Extract OSF GUIDs and Waterbutler IDs from various types of inputs. Valid
looking IDs are returned as \code{osf_id} objects.
}
\section{Identifier types}{

There are 2 types of identifiers you'll encounter on OSF. The first is the
globally unique identifier, or GUID, that OSF assigns to every entity. A
valid OSF GUID consists of 5 alphanumeric characters. The second type of
identifier is specific to files stored on OSF. All file operations on OSF are
handled via Waterbutler. A valid Waterbutler ID consists of 24 alphanumeric
characters.
}

\examples{
\dontrun{
# extract a GUID from an OSF URL
proj_id <- as_id("https://osf.io/7zqxp/")

# extract waterbutler IDs from an `osf_tbl_file`` with multiple files
osf_retrieve_node(proj_id) \%>\%
  osf_ls_files() \%>\%
  as_id()
}
}
