% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osf_create.R
\name{osf_create}
\alias{osf_create}
\alias{osf_create_project}
\alias{osf_create_component}
\title{Create a new project or component on OSF}
\usage{
osf_create_project(
  title,
  description = NULL,
  public = FALSE,
  category = "project"
)

osf_create_component(
  x,
  title,
  description = NULL,
  public = FALSE,
  category = NULL
)
}
\arguments{
\item{title, description}{Set a title (required) and, optionally, a
description.}

\item{public}{Logical, should it be publicly available (\code{TRUE}) or private
(\code{FALSE}, the default)?}

\item{category}{Character string, specify a category to change the icon
displayed on OSF. The defaults are \code{"project"} for projects and
\code{"uncategorized"} for components. The specified category can be easily
changed later on OSF. Valid category options include:
\itemize{
\item analysis
\item communication
\item data
\item hypothesis
\item instrumentation
\item methods and measures
\item procedure
\item project
\item software
\item other
}}

\item{x}{An \code{\link{osf_tbl_node}} with a single OSF project or component that will
serve as the new sub-component's parent node.}
}
\value{
An \code{\link{osf_tbl_node}} containing the new project or component.
}
\description{
Use \code{osf_create_project()} to create a new top-level project on OSF. A nested
component can be created by providing an \code{\link{osf_tbl_node}} containing an
existing project or component to \code{osf_create_component()}'s \code{x} argument.
}
\section{OSF nodes}{


Projects and components are both implemented as \emph{nodes} on OSF. The only
distinction between the two is that a project is a top-level node, and a
component must have a parent node (i.e., must be a sub-component of another
project or component). Because projects and components are functionally
identical, osfr uses the same \code{\link{osf_tbl_node}} class to represent both.
}

\examples{
\dontrun{
# create a new public project
project <- osf_create_project(title = "Private OSF Project", public = TRUE)

# add a private component to the new project
component <- osf_create_component(project, title = "Project Data")
}
}
\references{
\enumerate{
\item OSF Guides: Create a Project.
\url{https://help.osf.io/hc/en-us/articles/360019737594-Create-a-Project}.
\item OSF Guides: Create a Component.
\url{https://help.osf.io/hc/en-us/articles/360019737614-Create-Components}.
}
}
