% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{unname_osmdata_sf}
\alias{unname_osmdata_sf}
\title{unname_osmdata_sf}
\usage{
unname_osmdata_sf(x)
}
\arguments{
\item{x}{An 'osmdata_sf' object returned from function of same name}
}
\value{
Same object, yet with no row names on geometry objects.
}
\description{
Remove names from \code{osmdata} geometry objects, for cases in which these cause
issues, particularly with plotting, such as
\url{https://github.com/rstudio/leaflet/issues/631}, or
\url{https://github.com/r-spatial/sf/issues/1177}. Note that removing these
names also removes any ability to inter-relate the different components of an
\code{osmdata} object, so use of this function is only recommended to resolve
issues such as those linked to above.
}
\examples{
\dontrun{
hampi_sf <- opq ("hampi india") \%>\%
            add_osm_feature (key="historic", value="ruins") \%>\%
            osmdata_sf ()
hampi_clean <- unname_osmdata_sf (hampi_sf)

# All coordinate matrices include rownames with OSM ID values:
head (as.matrix (hampi_sf$osm_lines$geometry [[1]]))
# But 'unname_osmdata_sf' removes both row and column names:
head (as.matrix (hampi_clean$osm_lines$geometry [[1]]))
}
}
\seealso{
Other transform: 
\code{\link{osm_elevation}()},
\code{\link{osm_poly2line}()},
\code{\link{trim_osmdata}()},
\code{\link{unique_osmdata}()}
}
\concept{transform}
