% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{oe_find}
\alias{oe_find}
\title{Get the location of files}
\usage{
oe_find(
  place,
  provider = "geofabrik",
  download_directory = oe_download_directory(),
  download_if_missing = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{place}{Description of the geographical area that should be matched with
a \code{.osm.pbf} file through the chosen \code{provider}. Can be either a length-1
character vector, an \code{sf} or \code{sfc} object, or a numeric vector of
coordinates with length 2. In the last case, it is assumed that the EPSG
code is 4326 specified as c(LON, LAT), while you can use any CRS with an
\code{sf} or \code{sfc} object. See Details and examples in \code{\link[=oe_match]{oe_match()}}.}

\item{provider}{Which provider should be used to download the data? Available
providers can be found with the following command: \code{\link[=oe_providers]{oe_providers()}}. For
\code{\link[=oe_get]{oe_get()}} and \code{\link[=oe_match]{oe_match()}}, if \code{place} is equal to \verb{ITS Leeds}, then
\code{provider} is set equal to \code{test}. This is just for simple examples and
internal tests.}

\item{download_directory}{Directory where the files downloaded by osmextract
are stored. By default it is equal to \code{\link[=oe_download_directory]{oe_download_directory()}}.}

\item{download_if_missing}{Attempt to download the file if it cannot be
found? \code{FALSE} by default.}

\item{quiet}{Boolean. If \code{FALSE}, the function prints informative messages.
Starting from \code{sf} version
\href{https://r-spatial.github.io/sf/news/index.html#version-0-9-6-2020-09-13}{0.9.6},
if \code{quiet} is equal to \code{FALSE}, then vectortranslate operations will
display a progress bar.}

\item{...}{Extra arguments that are passed to \code{\link[=oe_match]{oe_match()}} and \code{\link[=oe_get]{oe_get()}}.
Please note that you cannot modify the argument \code{download_only}.}
}
\value{
A character vector of length one (or two) representing the path(s) of the
corresponding \code{.pbf} (and \code{.gpkg}) files.
}
\description{
This function takes a \code{place} name and it returns the path of \code{.pbf} and
\code{.gpkg} files associated with it.
}
\details{
The matching between the existing files (saved in a directory
specified by \code{download_directory} parameter) and the input \code{place} is
performed using \code{list.files}, setting a pattern equal to the basename of
the URL associated to the input \code{place}. For example, if you specify
\code{place = "Isle of Wight"}, then the input \code{place} is matched with a URL of
a \code{.osm.pbf} file (via \code{\link[=oe_match]{oe_match()}}) and the matching is performed setting a
pattern equal to the basename of that URL.

If there is no file in \code{download_directory} that can be matched with the
basename and \code{download_if_missing} parameter is equal to \code{TRUE}, then the
function tries to download and translate a new file from the chosen
provider (\code{geofabrik} is the default provider). If \code{download_if_missing}
parameter is equal to \code{FALSE} (default value), then the function stops with
an error.
}
\examples{
res = oe_get("ITS Leeds", quiet = TRUE, download_directory = tempdir())
oe_find("ITS Leeds", provider = "test", download_directory = tempdir())

\dontrun{
  oe_find("Isle of Wight", download_directory = tempdir())
  oe_find("Malta", download_if_missing = TRUE, download_directory = tempdir())
  oe_find(
    "Leeds",
    provider = "bbbike",
    download_if_missing = TRUE,
    download_directory = tempdir()
  )}
# Remove .pbf and .gpkg files in tempdir
# (since they may interact with other examples)
file.remove(list.files(path = tempdir(), pattern = "(pbf|gpkg)", full.names = TRUE))
}
