/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;
import java.io.File;

public class MeanSizeOutput
extends AbstractOutput {
    private double[] meanSize;
    private double[] abundance;

    public MeanSizeOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.meanSize = new double[this.getNSpecies()];
        this.abundance = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int i;
            if (!this.includeClassZero() && school.getAgeDt() < school.getSpecies().getAgeClassZero()) continue;
            int n = i = school.getSpeciesIndex();
            this.meanSize[n] = this.meanSize[n] + school.getInstantaneousAbundance() * (double)school.getLength();
            int n2 = i;
            this.abundance[n2] = this.abundance[n2] + school.getInstantaneousAbundance();
        }
    }

    @Override
    public void write(float time) {
        for (int i = 0; i < this.getConfiguration().getNSpecies(); ++i) {
            this.meanSize[i] = this.abundance[i] > 0.0 ? (double)((float)(this.meanSize[i] / this.abundance[i])) : Double.NaN;
        }
        this.writeVariable(time, this.meanSize);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder("SizeIndicators");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_meanSize_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        StringBuilder str = new StringBuilder("Mean size of fish species in cm, weighted by fish numbers, and ");
        if (this.includeClassZero()) {
            str.append("including ");
        } else {
            str.append("excluding ");
        }
        str.append("first ages specified in input");
        return str.toString();
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

