% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bookdown_to_leanpub.R
\name{bookdown_to_embed_leanpub}
\alias{bookdown_to_embed_leanpub}
\title{Convert Bookdown to Embed version of Leanpub}
\usage{
bookdown_to_embed_leanpub(
  path = ".",
  chapt_img_key = NULL,
  bookdown_index = file.path(base_url, "index.html"),
  base_url = NULL,
  clean_up = FALSE,
  default_img = NULL,
  render = TRUE,
  output_dir = "manuscript",
  make_book_txt = FALSE,
  quiz_dir = "quizzes",
  run_quiz_checks = FALSE,
  remove_resources_start = FALSE,
  verbose = TRUE,
  footer_text = ""
)
}
\arguments{
\item{path}{path to the bookdown book, must have a `_bookdown.yml` file}

\item{chapt_img_key}{File path to a TSV whose contents are the chapter urls (`url`),
the chapter titles (`chapt_title`), the file path to the image to be used for the chapter (`img_path`).
Column names `url`, `chapt_title`, and `img_path` must be used.
If no chapter title column supplied, the basename of the url will be used,
If no image column supplied, default image used.}

\item{bookdown_index}{The file path of the rendered bookdown index.html file}

\item{base_url}{The base url of where the chapters are published -- the url to provide to the iframe in Leanpub
e.g. https://jhudatascience.org/OTTR_Template/coursera}

\item{clean_up}{TRUE/FALSE the old output directory should be deleted and
everything created fresh.}

\item{default_img}{A google slide link to the default image to be used for all chapters}

\item{render}{if `TRUE`, then [bookdown::render_book()] will be run on each Rmd.}

\item{output_dir}{output directory to put files.  It should likely be
relative to path}

\item{make_book_txt}{Should [ottrpal::bookdown_to_book_txt()] be run
to create a `Book.txt` in the output directory?}

\item{quiz_dir}{directory that contains the quiz .md files that should be
checked and incorporated into the Book.txt file. If you don't have quizzes,
set this to NULL}

\item{run_quiz_checks}{TRUE/FALSE run quiz checks}

\item{remove_resources_start}{remove the word `resources/` at the front
of any image path.}

\item{verbose}{print diagnostic messages}

\item{footer_text}{Optionally can add a bit of text that will be added to the
end of each file before the references section.}
}
\value{
A directory of output files in a folder 'manuscript' for publishing on Leanpub.
}
\description{
Convert Bookdown to Embed version of Leanpub
}
\examples{
\dontrun{

ottrpal::bookdown_to_embed_leanpub(
  base_url = "https://jhudatascience.org/OTTR_Template/",
  make_book_txt = TRUE,
  quiz_dir = NULL
)
}
}
