% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouxy.r
\name{regboundfcn}
\alias{regboundfcn}
\title{range for regression parameters}
\usage{
regboundfcn(olssum = olssum)
}
\arguments{
\item{olssum}{summary statistics from ordinary least square performed by \code{\link[stats:lm]{lm}}.}
}
\value{
A vectors of values containing the range of regression parameters
}
\description{
Set up range for regression parameters
}
\details{
An ordinary least square analysis is performed on regression \eqn{y \sim x_1 + x_2}. Parameter estimates \eqn{\hat{b}} and standard errors \eqn{sd(\hat{b})} are used to construct the bound using formula \eqn{\hat{b}\pm 3sd(\hat{b})}.
}
\examples{
resptrait<-rnorm(10)
predtrait1<-rnorm(10)
predtrait2<-rnorm(10)
olssum <- base::summary(lm(resptrait~predtrait1+predtrait2))
regboundfcn(olssum=olssum)


}
