% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataLoader.R
\name{dataLoader}
\alias{dataLoader}
\title{Load the event-logs}
\usage{
dataLoader(verbose.mode = TRUE)
}
\arguments{
\item{verbose.mode}{boolean. If TRUE some messages will appear in console, during the computation; otherwise the computation will be silent.}
}
\description{
A loader for csv based log files. It also calculates the footprint table, transition matrix probabilities, and presents data in different shapes. The public methods are:
             \itemize{
             \item \code{dataLoader() } the costructor
             \item \code{load.csv( ... ) } loads the csv file into the \code{dataLoader} object
             \item \code{load.data.frame() } loads a data.frame into the \code{dataLoader} object
             \item \code{getData() } return the processed, previously-loaded, data
             \item \code{removeEvents() } remove the events in the array passed as argument (dual of \code{dataLoader::keepOnlyEvents()} )
             \item \code{keepOnlyEvents() } keep only the events in the array passed as argument (dual of \code{dataLoader::removeEvents()} )
             \item \code{addDictionary() } add a dictionary in order, afterward, to translate or group some event name
             \item \code{getTranslation() } perform a translation applying the given dictionary to the loaded csv or data.frame
             \item \code{plot.Timeline() } plot the timeline of the events regarding a single patient 
             } 
             In order to better undestand the use of such methods, please visit: www.pminer.info
             
             The consturctor admit the following parameters:
verbose.mode are some notification wished, during the computation? The defaul value is \code{true}
}
\examples{
\dontrun{

# create a Loader
obj.L<-dataLoader();   

# Load a .csv 
obj.L$load.csv(nomeFile = "../otherFiles/mammella.csv",
IDName = "CODICE_SANITARIO_ADT",
EVENTName = "DESC_REPARTO_RICOVERO",
dateColumnName = "DATA_RICOVERO")

# return the results
obj.L$getData()

}
}

