% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/travis.R
\name{deploy_travis}
\alias{deploy_travis}
\title{Deploy to Github Pages from Travis-CI}
\usage{
deploy_travis(repo = gsub(".*://([^.]*)\\\\.github.io/([^/]*).*",
  "\\\\1/\\\\2", read_rmd_yaml(file.path("vignettes", "docs.Rmd"))$redirect),
  valid_branches = "master", token_key = "GITHUB_PAT",
  email = "travis@travis-ci.org", name = "Travis CI",
  push_branch = "gh-pages", output_dir = "_gh-pages",
  build_fn = function(ouput_dir, ...) {     devtools::install(".")    
  build_vignettes(pkg = ".", output_dir = output_dir) })
}
\arguments{
\item{repo}{character string that has the form USER/REPO}

\item{valid_branches}{branch name(s) that are allowed to deploy}

\item{token_key}{key name that will be autofilled}

\item{email}{email for commit}

\item{name}{name for commit}

\item{push_branch}{branch the website should be pushed to. Defaults to 'gh-pages'}

\item{output_dir}{output directory to put the website in}

\item{build_fn}{function to build the documentation. This function must take \code{ouput_dir} and \code{...} for future expansion.  Defaults to \code{packagedocs::\link{build_vignettes}}}
}
\description{
This function will generate both the CRAN vignettes and gh-pages vignettes. It will look for your personal github token (\code{GITHUB_TOKEN}) that the function may deploy to the gh-pages branch of the your package's github repo.
}
\details{
The function is designed so that packagedocs will never ask for your token directly. It will only issue commands to the terminal which should evaluate with the necessary information.
}

