% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_cyclomatic_complexity}
\alias{check_cyclomatic_complexity}
\title{Check \verb{Cyclomatic Complexity}}
\usage{
check_cyclomatic_complexity(path = ".", max_complexity = 10)
}
\arguments{
\item{path}{Path to the package directory (see
\code{\link[devtools:as.package]{devtools::as.package}}).}

\item{max_complexity}{The maximum \verb{cyclomatic complexity}
(which must not be exceeded).}
}
\value{
\code{\link[base:invisible]{Invisibly} \link[base:logical]{TRUE}} if
maximum \verb{cyclomatic complexity} is not exceeded, throws an error
otherwise.
}
\description{
Run
\code{\link[cyclocomp:cyclocomp_package_dir]{cyclocomp_package_dir}} on the
package throwing an error when the maximum complexity is exceeded.
}
\examples{
\dontrun{
# download and untar sources of some archived package
package  <- "excerptr"
root <- paste0("http://cran.r-project.org/src/contrib/Archive/", package)
version <- "1.0.0"
tarball <- paste0(paste(package, version, sep = "_"), ".tar.gz")
remote_tarball <- paste(root, tarball, sep = "/")
local_tarball <- file.path(tempdir(), tarball)
utils::download.file(remote_tarball, local_tarball)
utils::untar(local_tarball, exdir = tempdir())
res <- tryCatch(check_cyclomatic_complexity(path = file.path(tempdir(),
                                                             package)),
                error = identity)
print(res)
}
}
\seealso{
Other maintenance functions: 
\code{\link{check_archive}()},
\code{\link{check_codetags}()},
\code{\link{check_news}()},
\code{\link{check_usage}()},
\code{\link{get_check_status}()}
}
\concept{maintenance functions}
