% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_last.R
\name{pac_islast}
\alias{pac_islast}
\title{Checking if a package version is the most recent one}
\usage{
pac_islast(pac, version = NULL, lib.loc = NULL, repos = biocran_repos())
}
\arguments{
\item{pac}{character a package name.}

\item{version}{character package version, by default the installed version is taken. Default: NULL}

\item{lib.loc}{character vector. Is omitted for non NULL version. Default: NULL}

\item{repos}{character vector base URLs of the repositories to use. By default checking CRAN and newest Bioconductor per R Version. Default \code{pacs::biocran_repos()}}
}
\value{
logical if a package is inside repositories.
}
\description{
checking if a package version is the most recent one, by default the installed version is compared.
}
\note{
Results are cached for 1 hour with \code{memoise} package.
For Bioconductor if package is the newest one per R version.
}
\examples{
\dontrun{
pac_islast("memoise")
pac_islast("dplyr", version = "1.0.0")
pac_islast("S4Vectors")
pac_islast("S4Vectors", version = pac_last("S4Vectors"))
}
}
