% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad.R
\name{pad}
\alias{pad}
\title{Pad the datetime column of a data frame.}
\usage{
pad(x, interval = NULL, start_val = NULL, end_val = NULL, by = NULL)
}
\arguments{
\item{x}{A data frame containing at least one variable of class \code{Date},
class \code{POSIXct} or class \code{POSIXlt}.}

\item{interval}{The interval of the returned datetime variable. When NULL the
the interval will be equal to the interval of the datetime variable. When
specified it can only be lower than the interval of the input data. See Details.}

\item{start_val}{An object of class \code{Date}, class \code{POSIXct} or
class \code{POSIXlt} that specifies the start of the returned datetime variable.
If NULL it will use the lowest value of the input variable.}

\item{end_val}{An object of class \code{Date}, class \code{POSIXct} or
class \code{POSIXlt} that specifies the end of returned datetime variable.
If NULL it will use the highest value of the input variable.}

\item{by}{Only needs to be specified when \code{x} contains multiple
variables of class \code{Date}, class \code{POSIXct} or
class \code{POSIXlt}. \code{by} indicates which variable to use for padding.}
}
\value{
The data frame \code{x} with the datetime variable padded. All other variables
in the data frame will have missing values at the rows that are padded.
}
\description{
\code{pad} will fill the gaps in incomplete datetime variables, by figuring out
what the interval of the data is and what instances are missing. It will insert
a record for each of the missing time points. For all
other variables in the data frame a missing value will be insterted at the padded rows.
}
\details{
The interval of a datetime variable is the time unit at which the
observations occur. The eight intervals in \code{padr} are from high to low
\code{year}, \code{quarter}, \code{month}, \code{week}, \code{day},
\code{hour}, \code{min}, and \code{sec}. \code{pad} will figure out
the interval of the input variable and will fill the gaps for the instances that
would be expected from the interval, but are missing in the input data.
See \code{vignette("padr")} for more information on \code{pad}.
See \code{vignette("padr_implementation")} for detailed information on
daylight savings time, different timezones, and the implementation of
\code{thicken}.
}
\examples{
simple_df <- data.frame(day = as.Date(c('2016-04-01', '2016-04-03')),
                        some_value = c(3,4))
pad(simple_df)

library(dplyr) # for the pipe operator
month <- seq(as.Date('2016-04-01'), as.Date('2017-04-01'),
              by = 'month')[c(1, 4, 5, 7, 9, 10, 13)]
month_df <- data.frame(month = month,
                       y = runif(length(month), 10, 20) \%>\% round)
# forward fill the padded values with tidyr's fill
month_df \%>\% pad \%>\% tidyr::fill(y)

# or fill all y with 0
month_df \%>\% pad \%>\% fill_by_value(y)

# padding a data.frame on group level
day_var <- seq(as.Date('2016-01-01'), length.out = 12, by = 'month')
x_df_grp <- data.frame(grp  = rep(LETTERS[1:3], each =4),
                       y    = runif(12, 10, 20) \%>\% round(0),
                       date = sample(day_var, 12, TRUE)) \%>\%
 arrange(grp, date)

x_df_grp \%>\% group_by(grp) \%>\% do(pad(.)) \%>\% ungroup \%>\%
tidyr::fill(grp)
}

