% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo.R
\name{repo_get}
\alias{repo_get}
\title{Query the currently configured CRAN-like repositories}
\usage{
repo_get(r_version = getRversion(), bioc = TRUE, cran_mirror = NULL)
}
\arguments{
\item{r_version}{R version to use to determine the correct Bioconductor
version, if \code{bioc = TRUE}.}

\item{bioc}{Whether to automatically add the Bioconductor repositories
to the result.}

\item{cran_mirror}{CRAN mirror to use. Leave it at \code{NULL} to use the
mirror in \code{getOption("repos")} or an automatically selected one.}
}
\description{
pak uses the \code{repos} option, see \code{\link[=options]{options()}}. It also automatically
adds a CRAN mirror if none is set up, and the correct version of the
Bioconductor repositories. See the \code{cran_mirror} and \code{bioc} arguments.
}
\details{
\code{repo_get()} returns the table of the currently configured repositories.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
repo_get()
\dontshow{\}) # examplesIf}
}
\seealso{
Other repository functions: 
\code{\link{repo_add}()},
\code{\link{repo_status}()}
}
\concept{repository functions}
