% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_deps}
\alias{local_deps}
\alias{local_deps_tree}
\alias{local_dev_deps}
\alias{local_dev_deps_tree}
\title{Dependencies of a package tree}
\usage{
local_deps(root = ".", upgrade = TRUE, dependencies = NA)

local_deps_tree(root = ".", upgrade = TRUE, dependencies = NA)

local_dev_deps(root = ".", upgrade = TRUE, dependencies = TRUE)

local_dev_deps_tree(root = ".", upgrade = TRUE, dependencies = TRUE)
}
\arguments{
\item{root}{Path to the package tree.}

\item{upgrade}{Whether to use the most recent available package
versions.}

\item{dependencies}{Which dependencies to print. Defaults to the hard
dependencies for \code{local_deps()} and \code{local_deps_tree()} and the hard
dependencies plus the development dependencies for \code{local_dev_deps()}
and \code{local_dev_deps_tree()}.}
}
\value{
All of these functions return the dependencies in a data
frame. \code{local_deps_tree()} and \code{local_dev_deps_tree()} also
print the dependency tree.
}
\description{
Dependencies of a package tree
}
\seealso{
Other local package trees: 
\code{\link{local_deps_explain}()},
\code{\link{local_install_deps}()},
\code{\link{local_install_dev_deps}()},
\code{\link{local_install}()},
\code{\link{local_package_trees}},
\code{\link{pak}()}
}
\concept{local package trees}
