% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{palasso}
\alias{palasso}
\alias{palasso-package}
\title{Paired lasso}
\usage{
palasso(y = y, X = X, max = 10, ...)
}
\arguments{
\item{y}{response\strong{:}
vector of length \eqn{n}}

\item{X}{covariates\strong{:}
list of matrices,
each with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{max}{maximum number of non-zero coefficients\strong{:}
positive numeric, or \code{NULL} (no sparsity constraint)}

\item{...}{further arguments for \code{\link[glmnet]{cv.glmnet}} or
\code{\link[glmnet]{glmnet}}}
}
\value{
This function returns an object of class \code{palasso}.
Available methods include
\code{\link[=predict.palasso]{predict}},
\code{\link[=coef.palasso]{coef}},
\code{\link[=weights.palasso]{weights}},
\code{\link[=fitted.palasso]{fitted}},
\code{\link[=residuals.palasso]{residuals}},
\code{\link[=deviance.palasso]{deviance}},
\code{\link[=logLik.palasso]{logLik}},
and \code{\link[=summary.palasso]{summary}}.
}
\description{
The function \code{palasso} fits the paired lasso.
Use this function if you have \emph{paired covariates}
and want a \emph{sparse model}.
}
\details{
Let \code{x} denote one entry of the list \code{X}. See \link[glmnet]{glmnet}
for alternative specifications of \code{y} and \code{x}. Among the further
arguments, \code{family} must equal \code{"gaussian"}, \code{"binomial"},
\code{"poisson"}, or \code{"cox"}, and \code{penalty.factor} must not be
used.

Hidden arguments:
Deactivate adaptive lasso by setting \code{adaptive} to \code{FALSE},
activate standard lasso by setting \code{standard} to \code{TRUE},
and activate shrinkage by setting \code{shrink} to \code{TRUE}.
}
\examples{
set.seed(1)
n <- 50; p <- 20
y <- rbinom(n=n,size=1,prob=0.5)
X <- lapply(1:2,function(x) matrix(rnorm(n*p),nrow=n,ncol=p))
object <- palasso(y=y,X=X,family="binomial") # adaptive=TRUE,standard=FALSE
names(object)

}
\references{
A Rauschenberger, I Ciocanea-Teodorescu, RX Menezes, MA Jonker,
and MA van de Wiel (2020). "Sparse classification with paired covariates."
\emph{Advances in Data Analysis and Classification}. 14:571-588.
\doi{10.1007/s11634-019-00375-6},
\href{https://link.springer.com/content/pdf/10.1007/s11634-019-00375-6.pdf}{pdf},
\email{armin.rauschenberger@uni.lu}
}
