% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{sim.Stasis}
\alias{sim.Stasis}
\title{Simulate Stasis time-series for trait evolution}
\usage{
sim.Stasis(
  ns = 20,
  theta = 0,
  omega = 0,
  vp = 1,
  nn = rep(20, ns),
  tt = 0:(ns - 1)
)
}
\arguments{
\item{ns}{number of populations in the sequence}

\item{theta}{mean of populations}

\item{omega}{variance among populations}

\item{vp}{phenotypic variance within populations}

\item{nn}{vector of population sample sizes}

\item{tt}{vector of population times (ages)}
}
\value{
a \code{paleoTS} object
}
\description{
Simulate Stasis time-series for trait evolution
}
\examples{
x <- sim.Stasis(omega = 0.5, vp = 0.1)
w.sta <- fitSimple(x, model = "Stasis")
w.ss  <- fitSimple(x, model = "StrictStasis")
compareModels(w.sta, w.ss)

}
\seealso{
\code{\link{sim.GRW}}, \code{\link{sim.OU}}, \code{\link{as.paleoTS}}
}
