% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.pfComposite}
\alias{plot.pfComposite}
\title{plot.pfComposite}
\usage{
\method{plot}{pfComposite}(x, type = "ci", conf = c(0.05, 0.95),
  palette = "jet", add = "NONE", text = FALSE, main = NULL, ...)
}
\arguments{
\item{x}{A "pfComposite" object.}

\item{type}{Character, type of plot among "ci", "prctile", "density"}

\item{conf}{Numeric, confidence levels.}

\item{palette}{Character, color palette used with type=c("prctile",
"density") among "jet" and "BW".}

\item{add}{Character, add="NONE" by default, add="sitenum" could be
specified to plot the sites number in eah bin along with the composite
curve.}

\item{main}{Character, title of the plot.}

\item{text}{Logical, text options.}

\item{\dots}{\dots{}}
}
\description{
Plot a pfComposite object
}
\examples{
## Composite charcoal record for North America:
ID=pfSiteSel(id_region=="WNA0",l12=1)
## Transform data
res3=pfTransform(ID,method=c("MinMax","Box-Cox","Z-Score"),BasePeriod=c(200,4000))

## Composite
comp=pfComposite(res3,bins=seq(0,5000,200))
plot(comp,type="density",smoothing=TRUE,spar=0.3)
}
\author{
O. Blarquez
}

