% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pfDotMap.r
\name{pfDotMap}
\alias{pfDotMap}
\title{Produce maps of paleofire data}
\usage{
pfDotMap(TR, tarAge, hw, binhw = 0.5 * mean(diff(tarAge)),
  fig.base.name = NULL, base.map = "coasts", grd.res = 5,
  grd.ext = c(-180, 180, -90, 90), grd.lonlat = NULL,
  proj4 = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs", n.boot = 1000,
  cx.minsize = 0.3, cx.mult = 1)
}
\arguments{
\item{TR}{An object returned by \code{\link{pfTransform}}}

\item{tarAge}{Numeric, the target ages for prebinning given in years (e.g.
tarAge = seq(0, 10000, 20)). If unspecified the sequence is defined as
tarAge=seq(from=min age, to=max Age, by=median resolution).}

\item{hw}{Numeric, the half window width for the locfit procedure (in
years).}

\item{binhw}{Numeric, bin half width for the prebinning procedure (use the
same value as tarAge intervals for overlapping bins or tarAge intervals/2
for non-overlapping bins).}

\item{fig.base.name}{Character sequence representing the base name for the
figures. Can be preceded by a path as long as all directories in the path
exist. One figure will be produced for each time bin, with years (and file
suffix) appended to the base name automatically. A value of \code{NULL}
(default) causes figures to be plotted to the current device in sequence.}

\item{base.map}{Currently, either \code{'coasts'} or \code{'countries'} to
choose which base map (from required library \code{'rworldmap'}) to be
plotted as the base map for all plots. Could easily be modified to accept
any SpatialPolygons object.}

\item{grd.res,grd.ext}{Desired grid resolution and extent in degrees. If
\code{grd.res} is a single number, the grid will be defined with equal
lon/lat resolution; a two-element vector (lon,lat) can also be supplied for
unequal resolution. \code{grd.ext} is specified as a vector of the form
\code{c(min-lon,max-lon,min-lat,max-lat)}.}

\item{grd.lonlat}{A data frame of coordinates for every grid cell center, to
be used in cases where an irregular grid is desired. Columns must be named
'lon' and 'lat'. If specified, grd.res and grd.ext are ignored. Note that
this option could have undesirable results for unusual grid definitions. In
particular, the maximum radius for including sites in a grid cell is always
calculated at the equator. For a regular lon/lat grid, this guarantees all
sites will be included in at least one cell, because equatorial cells are
largest at the equator. If an irregular grid is specified such that this is
not true, the maximum radius calculated could lead to sites excluded from
all cells. In this case a warning is printed but the function proceeds
anyway.}

\item{proj4}{proj.4 string representing the desired projection for plotted
maps. Default is unprojected. See \url{http://www.spatialreference.org} to
look up the string for your favorite projections.}

\item{n.boot}{Number of bootstrap replicates to use when creating confidence
intervals around each grid-cell mean. In each time bin X grid cell
combination, replicates consist of composite z-score values for that bin,
randomly sampled (with replacement) from sites within the grid cell (see
'Details' for precise description of sites included in each cell). I.e., no
temporal bootstrapping is done here, so that bootstrap CI reflect only
spatial variability.}

\item{cx.minsize,cx.mult}{Parameters that crudely adjust plotted dot size.
cx.minsize defines the minimum cex applied to any point in any map, cx.mult
scales all points by an equivalent factor.}
}
\value{
Plots are produced on the current device or in pdf files defined by
\code{fig.base.name}. In addition, a named list of useful objects is
returned:

\item{COMP}{ The binned composite generated for plotting.  } \item{bins}{
The list of bin endpoints.  } \item{sp.grd}{ A
\code{\link[sp]{SpatialPointsDataFrame-class}} object containing all the
grid-level statistics produced and plotted (mean influx value, bootstrap
confidence interval, and number of sites per grid cell).  } \item{sp.sites}{
A \code{\link[sp]{SpatialPointsDataFrame-class}} object representing the
number of grid cells influenced by each site.  } \item{plots}{ A list with
one element for each bin. These elements are themselves named lists of
trellis objects representing each of the plots produced ("mean",
"sitesPerCell", "cellsPerSite", "timeSeries"). Note that these objects can
be edited to some degree with the \code{\link[lattice]{update.trellis}}
function, and plotted or used in layouts as any other trellis graphics can.
}
}
\description{
Produce map graphics representing spatial variability in charcoal data from
the Global Charcoal Database.
}
\details{
Takes any pfTransform object as input, and allows any set of one or more
time bins to be specified for plotting (one plot per bin). Time bins are
specified as for pfCompositeLF (which is called by pfSimpleGrid. The extent,
resolution, and projection of the desired grid are also user-specified.

Results will be plotted on a regular lon/lat grid. To determine which sites
contribute to each grid cell value, the code searches within a specified
great circle distance (i.e. on the surface of the globe) around each grid
cell center. To avoid missing any sites, the distance is set equal to the
greatest distance from a grid cell center to its most distant corner, which
occurs at the equator where grid cells are largest. This conservative
approach will result in many sites falling within multiple grid boxes. At
all latitudes, the defined radii will overlap near the edges of the grid
boxes. At higher latitudes, the lon/lat grid cells are physically much
smaller, so overlap will be considerably greater. There are alternatives,
like using a grid that is irregular in terms of lon/laton, or changing the
area of grid cells depending on latitude. But all have their tradeoffs, and
this one is simple.

Current version produces plots of mean CHAR, number of sites per grid cell,
and number of grid cells contributed to by each site (due to overlapping
radii described above). The mean plot additionally shows points in two
sizes, representing those mean values whose 95"\%" confidence intervals do
(small dots) or do not (large dots) contain zero. Finally, a time series is
plotted in each figure with the current time bin highlighted.
}
\examples{
\dontrun{
## Composite charcoal record for North America:
ID=pfSiteSel(id_region==c("WNA0"), l12==1 & long<(-130))
plot(ID)

## Transform data
res3=pfTransform(ID,method=c("MinMax","Box-Cox","Z-Score"),BasePeriod=c(200,4000))

## Plot maps for 1000-yr bins spanning 3-0 kBP
# dev.new(width=10,height=10) # A big plot area helps.
dotmap = pfDotMap( TR=res3, tarAge=seq(0,2000,1000), hw=500, grd.ext=c(-170,-80,40,80),
                   cx.minsize=2,cx.mult=3)
summary(dotmap)

# Plot the mean map from the first time bin
# newmap = update(dotmap$plots[[1]]$mean, main="A relabeled map")
# newmap
}
}
\author{
R. Kelly
}
\references{
Power, M., J. Marlon, N. Ortiz, P. Bartlein, S. Harrison, F.
Mayle, A. Ballouche, R. Bradshaw, C. Carcaillet, C. Cordova, S. Mooney, P.
Moreno, I. Prentice, K. Thonicke, W. Tinner, C. Whitlock, Y. Zhang, Y. Zhao,
A. Ali, R. Anderson, R. Beer, H. Behling, C. Briles, K. Brown, A. Brunelle,
M. Bush, P. Camill, G. Chu, J. Clark, D. Colombaroli, S. Connor, A. L.
Daniau, M. Daniels, J. Dodson, E. Doughty, M. Edwards, W. Finsinger, D.
Foster, J. Frechette, M. J. Gaillard, D. Gavin, E. Gobet, S. Haberle, D.
Hallett, P. Higuera, G. Hope, S. Horn, J. Inoue, P. Kaltenrieder, L.
Kennedy, Z. Kong, C. Larsen, C. Long, J. Lynch, E. Lynch, M. McGlone, S.
Meeks, S. Mensing, G. Meyer, T. Minckley, J. Mohr, D. Nelson, J. New, R.
Newnham, R. Noti, W. Oswald, J. Pierce, P. Richard, C. Rowe, M. Sanchez
Goni, B. Shuman, H. Takahara, J. Toney, C. Turney, D. Urrego-Sanchez, C.
Umbanhowar, M. Vandergoes, B. Vanniere, E. Vescovi, M. Walsh, X. Wang, N.
Williams, J. Wilmshurst, and J. Zhang. 2008. Changes in fire regimes since
the Last Glacial Maximum: an assessment based on a global synthesis and
analysis of charcoal data. Climate Dynamics 30:887-907.
}

