#' waxsys.pro.df
#'
#' Protein-alignment data.frame from the Waxsystermes Virus example.
#' Generated by read.pro() from DIAMOND-alignment of an input sequence
#' against PalmDB.
#'
#'#' \itemize{
#'   \item qseqid. Query or input sequence name ("SRR9968562_waxsystermes_virus_microassembly")
#'   \item qstart. Coordinate of alignment start, 1 based
#'   \item qend. Coordinate of alignment end, 1 based
#'   \item qlen. Length of aligned sequence on query
#'   \item sseqid. Subject (palmDB) sequence identifier, sOTU used.
#'   \item sstart. Coordinate of alignment start, 1 based
#'   \item send. Coordinate of alignment end, 1 based
#'   \item slen. Length of aligned sequence on query
#'   \item pident. Percent AA-identity between query and subject. (0--100)
#'   \item evalue. Expectance value for alignment
#'   \item cigar. CIGAR alignment string for query alignment
#'   \item full_sseq. Complete subject sequence (including non-aligned)
#'   \item tspe. Taxonomic species of the palmDB match if available, else "."
#'   \item tfam. Taxonomic family of the palmDB match if available, else "."
#'   \item tphy. Taxonomic phylum of the palmDB match if available, else "."
#' }
#'
#' @name waxsys.pro.df
#' @usage data(waxsys.pro.df)
#' @docType data
#' @format data.frame with 223 obs. of 15 variables
#' @keywords waxsystermes-example datasets
#' @source \href{https://github.com/ababaian/serratus/wiki/Find_novel_viruses_B_palmdb}{Waxsystermes Virus Tutorial}
#'
NULL